/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http;

import discord4j.rest.http.WriterStrategy;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClient;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public class FormUrlEncodedWriterStrategy
implements WriterStrategy<String> {
    private static final Logger log = Loggers.getLogger(FormUrlEncodedWriterStrategy.class);

    @Override
    public boolean canWrite(@Nullable Class<?> type, @Nullable String contentType) {
        return type != null && contentType != null && contentType.startsWith("application/x-www-form-urlencoded") && String.class.isAssignableFrom(type);
    }

    @Override
    public Mono<HttpClient.ResponseReceiver<?>> write(HttpClient.RequestSender sender, @Nullable String body) {
        if (body == null) {
            return Mono.error((Throwable)new RuntimeException("Missing body"));
        }
        Mono source = Mono.just((Object)body).doOnNext(payload -> {
            if (log.isTraceEnabled()) {
                log.trace("{}", new Object[]{body});
            }
        });
        return Mono.fromCallable(() -> sender.send((Publisher)ByteBufFlux.fromString((Publisher)source, (Charset)StandardCharsets.UTF_8, (ByteBufAllocator)ByteBufAllocator.DEFAULT)));
    }
}

