/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.GuildEmojiCreateMonoGenerator;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class GuildEmojiCreateMono
extends GuildEmojiCreateMonoGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final String name;
    private final Image image;
    private final List<Snowflake> roles;
    private final Guild guild;

    private GuildEmojiCreateMono(String name, Image image, Guild guild) {
        this.name = Objects.requireNonNull(name, "name");
        this.image = Objects.requireNonNull(image, "image");
        this.guild = Objects.requireNonNull(guild, "guild");
        this.reason = null;
        this.roles = GuildEmojiCreateMono.createUnmodifiableList(false, GuildEmojiCreateMono.createSafeList(super.roles(), true, false));
    }

    private GuildEmojiCreateMono(@reactor.util.annotation.Nullable String reason, String name, Image image, List<Snowflake> roles, Guild guild) {
        this.reason = reason;
        this.name = name;
        this.image = image;
        this.roles = roles;
        this.guild = guild;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Image image() {
        return this.image;
    }

    @Override
    public List<Snowflake> roles() {
        return this.roles;
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final GuildEmojiCreateMono withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new GuildEmojiCreateMono(value, this.name, this.image, this.roles, this.guild);
    }

    public final GuildEmojiCreateMono withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new GuildEmojiCreateMono(this.reason, newValue, this.image, this.roles, this.guild);
    }

    public final GuildEmojiCreateMono withImage(Image value) {
        if (this.image == value) {
            return this;
        }
        Image newValue = Objects.requireNonNull(value, "image");
        return new GuildEmojiCreateMono(this.reason, this.name, newValue, this.roles, this.guild);
    }

    public final GuildEmojiCreateMono withRoles(Snowflake ... elements) {
        List<Snowflake> newValue = GuildEmojiCreateMono.createUnmodifiableList(false, GuildEmojiCreateMono.createSafeList(Arrays.asList(elements), true, false));
        return new GuildEmojiCreateMono(this.reason, this.name, this.image, newValue, this.guild);
    }

    public final GuildEmojiCreateMono withRoles(Iterable<? extends Snowflake> elements) {
        if (this.roles == elements) {
            return this;
        }
        List<Snowflake> newValue = GuildEmojiCreateMono.createUnmodifiableList(false, GuildEmojiCreateMono.createSafeList(elements, true, false));
        return new GuildEmojiCreateMono(this.reason, this.name, this.image, newValue, this.guild);
    }

    public final GuildEmojiCreateMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new GuildEmojiCreateMono(this.reason, this.name, this.image, this.roles, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildEmojiCreateMono && this.equalTo(0, (GuildEmojiCreateMono)another);
    }

    private boolean equalTo(int synthetic, GuildEmojiCreateMono another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.image.equals((Object)another.image) && this.roles.equals(another.roles) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.image.hashCode();
        h += (h << 5) + this.roles.hashCode();
        h += (h << 5) + this.guild.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "GuildEmojiCreateMono{reason=" + this.reason + ", name=" + this.name + ", image=" + this.image + ", roles=" + this.roles + ", guild=" + this.guild + "}";
    }

    public static GuildEmojiCreateMono of(String name, Image image, Guild guild) {
        return new GuildEmojiCreateMono(name, image, guild);
    }

    static GuildEmojiCreateMono copyOf(GuildEmojiCreateMonoGenerator instance) {
        if (instance instanceof GuildEmojiCreateMono) {
            return (GuildEmojiCreateMono)instance;
        }
        return GuildEmojiCreateMono.of(instance.name(), instance.image(), instance.guild()).withReason(instance.reason()).withRoles(instance.roles());
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }
}

