/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.ImmutableEmbedCreateFields;
import discord4j.core.spec.InlineFieldStyle;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.core.spec.Spec;
import discord4j.discordjson.json.EmbedAuthorData;
import discord4j.discordjson.json.EmbedFieldData;
import discord4j.discordjson.json.EmbedFooterData;
import discord4j.discordjson.possible.Possible;
import java.util.Optional;
import org.immutables.value.Value;
import reactor.util.annotation.Nullable;

@InlineFieldStyle
@Value.Enclosing
public final class EmbedCreateFields {
    private EmbedCreateFields() {
        throw new AssertionError();
    }

    @Value.Immutable
    public static interface Field
    extends Spec<EmbedFieldData> {
        public static Field of(String name, String value, boolean inline) {
            return ImmutableEmbedCreateFields.Field.of(name, value, inline);
        }

        public String name();

        public String value();

        public boolean inline();

        @Override
        default public EmbedFieldData asRequest() {
            return EmbedFieldData.builder().name(this.name()).value(this.value()).inline(Boolean.valueOf(this.inline())).build();
        }
    }

    @Value.Immutable
    public static interface Author
    extends Spec<EmbedAuthorData> {
        public static Author of(String name, @Nullable String url, @Nullable String iconUrl) {
            return ImmutableEmbedCreateFields.Author.of(name, url, iconUrl);
        }

        public String name();

        @Nullable
        public String url();

        @Nullable
        public String iconUrl();

        @Override
        default public EmbedAuthorData asRequest() {
            String url = this.url();
            return EmbedAuthorData.builder().name(this.name()).url(url == null ? Possible.absent() : Possible.of(Optional.of(url))).iconUrl(InternalSpecUtils.toPossible(this.iconUrl())).build();
        }
    }

    @Value.Immutable
    public static interface Footer
    extends Spec<EmbedFooterData> {
        public static Footer of(String text, @Nullable String iconUrl) {
            return ImmutableEmbedCreateFields.Footer.of(text, iconUrl);
        }

        public String text();

        @Nullable
        public String iconUrl();

        @Override
        default public EmbedFooterData asRequest() {
            return EmbedFooterData.builder().text(this.text()).iconUrl(InternalSpecUtils.toPossible(this.iconUrl())).build();
        }
    }
}

