/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.spec.BulkBanRequestSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class BulkBanRequestSpec
implements BulkBanRequestSpecGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final List<Snowflake> userIds;
    private final Integer deleteMessageSeconds_value;
    private final boolean deleteMessageSeconds_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private BulkBanRequestSpec(@reactor.util.annotation.Nullable String reason, List<Snowflake> userIds, Possible<Integer> deleteMessageSeconds) {
        this.reason = reason;
        this.userIds = userIds;
        Possible<Integer> deleteMessageSeconds$impl = deleteMessageSeconds;
        this.deleteMessageSeconds_value = deleteMessageSeconds$impl.toOptional().orElse(null);
        this.deleteMessageSeconds_absent = deleteMessageSeconds$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public List<Snowflake> userIds() {
        return this.userIds;
    }

    @Override
    public Possible<Integer> deleteMessageSeconds() {
        return this.deleteMessageSeconds_absent ? Possible.absent() : Possible.of((Object)this.deleteMessageSeconds_value);
    }

    public final BulkBanRequestSpec withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new BulkBanRequestSpec(value, this.userIds, this.deleteMessageSeconds());
    }

    public final BulkBanRequestSpec withUserIds(Snowflake ... elements) {
        List<Snowflake> newValue = BulkBanRequestSpec.createUnmodifiableList(false, BulkBanRequestSpec.createSafeList(Arrays.asList(elements), true, false));
        return new BulkBanRequestSpec(this.reason, newValue, this.deleteMessageSeconds());
    }

    public final BulkBanRequestSpec withUserIds(Iterable<? extends Snowflake> elements) {
        if (this.userIds == elements) {
            return this;
        }
        List<Snowflake> newValue = BulkBanRequestSpec.createUnmodifiableList(false, BulkBanRequestSpec.createSafeList(elements, true, false));
        return new BulkBanRequestSpec(this.reason, newValue, this.deleteMessageSeconds());
    }

    public BulkBanRequestSpec withDeleteMessageSeconds(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new BulkBanRequestSpec(this.reason, this.userIds, newValue);
    }

    public BulkBanRequestSpec withDeleteMessageSeconds(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new BulkBanRequestSpec(this.reason, this.userIds, (Possible<Integer>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BulkBanRequestSpec && this.equalTo(0, (BulkBanRequestSpec)another);
    }

    private boolean equalTo(int synthetic, BulkBanRequestSpec another) {
        return Objects.equals(this.reason, another.reason) && this.userIds.equals(another.userIds) && this.deleteMessageSeconds().equals(another.deleteMessageSeconds());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.userIds.hashCode();
        h += (h << 5) + this.deleteMessageSeconds().hashCode();
        return h;
    }

    public String toString() {
        return "BulkBanRequestSpec{reason=" + this.reason + ", userIds=" + this.userIds + ", deleteMessageSeconds=" + this.deleteMessageSeconds().toString() + "}";
    }

    static BulkBanRequestSpec copyOf(BulkBanRequestSpecGenerator instance) {
        if (instance instanceof BulkBanRequestSpec) {
            return (BulkBanRequestSpec)instance;
        }
        return BulkBanRequestSpec.builder().from(instance).build();
    }

    public boolean isDeleteMessageSecondsPresent() {
        return !this.deleteMessageSeconds_absent;
    }

    public Integer deleteMessageSecondsOrElse(Integer defaultValue) {
        return !this.deleteMessageSeconds_absent ? this.deleteMessageSeconds_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private Possible<Integer> deleteMessageSeconds_possible = Possible.absent();
        @Nullable
        private String reason;
        private List<Snowflake> userIds = new ArrayList<Snowflake>();

        private Builder() {
        }

        public final Builder from(BulkBanRequestSpec instance) {
            return this.from((BulkBanRequestSpecGenerator)instance);
        }

        final Builder from(BulkBanRequestSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.addAllUserIds(instance.userIds());
            this.deleteMessageSeconds(instance.deleteMessageSeconds());
            return this;
        }

        public final Builder reason(@reactor.util.annotation.Nullable String reason) {
            this.reason = reason;
            return this;
        }

        public final Builder addUserId(Snowflake element) {
            this.userIds.add(Objects.requireNonNull(element, "userIds element"));
            return this;
        }

        public final Builder addUserIds(Snowflake ... elements) {
            for (Snowflake element : elements) {
                this.userIds.add(Objects.requireNonNull(element, "userIds element"));
            }
            return this;
        }

        public final Builder userIds(Iterable<? extends Snowflake> elements) {
            this.userIds.clear();
            return this.addAllUserIds(elements);
        }

        public final Builder addAllUserIds(Iterable<? extends Snowflake> elements) {
            for (Snowflake snowflake : elements) {
                this.userIds.add(Objects.requireNonNull(snowflake, "userIds element"));
            }
            return this;
        }

        public Builder deleteMessageSeconds(Possible<Integer> value) {
            this.deleteMessageSeconds_possible = value;
            return this;
        }

        public Builder deleteMessageSeconds(Integer value) {
            this.deleteMessageSeconds_possible = Possible.of((Object)value);
            return this;
        }

        public BulkBanRequestSpec build() {
            return new BulkBanRequestSpec(this.reason, BulkBanRequestSpec.createUnmodifiableList(true, this.userIds), this.deleteMessageSeconds_build());
        }

        private Possible<Integer> deleteMessageSeconds_build() {
            return this.deleteMessageSeconds_possible;
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build BulkBanRequestSpec, attribute initializers form cycle " + attributes;
        }
    }
}

