/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.spec.AutoModRuleEditSpecGenerator;
import discord4j.discordjson.json.AutoModActionData;
import discord4j.discordjson.json.AutoModTriggerMetaData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class AutoModRuleEditSpec
implements AutoModRuleEditSpecGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final Integer eventType_value;
    private final boolean eventType_absent;
    private final AutoModTriggerMetaData triggerMetaData_value;
    private final boolean triggerMetaData_absent;
    private final List<AutoModActionData> actions_value;
    private final boolean actions_absent;
    private final Boolean enabled_value;
    private final boolean enabled_absent;
    private final List<Snowflake> exemptRoles_value;
    private final boolean exemptRoles_absent;
    private final List<Snowflake> exemptChannels_value;
    private final boolean exemptChannels_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private AutoModRuleEditSpec(@reactor.util.annotation.Nullable String reason, Possible<String> name, Possible<Integer> eventType, Possible<AutoModTriggerMetaData> triggerMetaData, Possible<List<AutoModActionData>> actions, Possible<Boolean> enabled, Possible<List<Snowflake>> exemptRoles, Possible<List<Snowflake>> exemptChannels) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<Integer> eventType$impl = eventType;
        Possible<AutoModTriggerMetaData> triggerMetaData$impl = triggerMetaData;
        Possible<List<AutoModActionData>> actions$impl = actions;
        Possible<Boolean> enabled$impl = enabled;
        Possible<List<Snowflake>> exemptRoles$impl = exemptRoles;
        Possible<List<Snowflake>> exemptChannels$impl = exemptChannels;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.eventType_value = eventType$impl.toOptional().orElse(null);
        this.eventType_absent = eventType$impl.isAbsent();
        this.triggerMetaData_value = triggerMetaData$impl.toOptional().orElse(null);
        this.triggerMetaData_absent = triggerMetaData$impl.isAbsent();
        this.actions_value = actions$impl.toOptional().orElse(null);
        this.actions_absent = actions$impl.isAbsent();
        this.enabled_value = enabled$impl.toOptional().orElse(null);
        this.enabled_absent = enabled$impl.isAbsent();
        this.exemptRoles_value = exemptRoles$impl.toOptional().orElse(null);
        this.exemptRoles_absent = exemptRoles$impl.isAbsent();
        this.exemptChannels_value = exemptChannels$impl.toOptional().orElse(null);
        this.exemptChannels_absent = exemptChannels$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    public Possible<Integer> eventType() {
        return this.eventType_absent ? Possible.absent() : Possible.of((Object)this.eventType_value);
    }

    @Override
    public Possible<AutoModTriggerMetaData> triggerMetaData() {
        return this.triggerMetaData_absent ? Possible.absent() : Possible.of((Object)this.triggerMetaData_value);
    }

    @Override
    public Possible<List<AutoModActionData>> actions() {
        return this.actions_absent ? Possible.absent() : Possible.of(this.actions_value);
    }

    @Override
    public Possible<Boolean> enabled() {
        return this.enabled_absent ? Possible.absent() : Possible.of((Object)this.enabled_value);
    }

    @Override
    public Possible<List<Snowflake>> exemptRoles() {
        return this.exemptRoles_absent ? Possible.absent() : Possible.of(this.exemptRoles_value);
    }

    @Override
    public Possible<List<Snowflake>> exemptChannels() {
        return this.exemptChannels_absent ? Possible.absent() : Possible.of(this.exemptChannels_value);
    }

    public final AutoModRuleEditSpec withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new AutoModRuleEditSpec(value, this.name(), this.eventType(), this.triggerMetaData(), this.actions(), this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleEditSpec withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new AutoModRuleEditSpec(this.reason, newValue, this.eventType(), this.triggerMetaData(), this.actions(), this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleEditSpec withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return new AutoModRuleEditSpec(this.reason, (Possible<String>)newValue, this.eventType(), this.triggerMetaData(), this.actions(), this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleEditSpec withEventType(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new AutoModRuleEditSpec(this.reason, this.name(), newValue, this.triggerMetaData(), this.actions(), this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleEditSpec withEventType(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new AutoModRuleEditSpec(this.reason, this.name(), (Possible<Integer>)newValue, this.triggerMetaData(), this.actions(), this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleEditSpec withTriggerMetaData(Possible<AutoModTriggerMetaData> value) {
        Possible<AutoModTriggerMetaData> newValue = Objects.requireNonNull(value);
        return new AutoModRuleEditSpec(this.reason, this.name(), this.eventType(), newValue, this.actions(), this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleEditSpec withTriggerMetaData(AutoModTriggerMetaData value) {
        Possible newValue = Possible.of((Object)value);
        return new AutoModRuleEditSpec(this.reason, this.name(), this.eventType(), (Possible<AutoModTriggerMetaData>)newValue, this.actions(), this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleEditSpec withActions(Possible<List<AutoModActionData>> possible) {
        Possible<List<AutoModActionData>> newValue = Objects.requireNonNull(possible);
        return new AutoModRuleEditSpec(this.reason, this.name(), this.eventType(), this.triggerMetaData(), newValue, this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleEditSpec withActions(Iterable<AutoModActionData> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new AutoModRuleEditSpec(this.reason, this.name(), this.eventType(), this.triggerMetaData(), (Possible<List<AutoModActionData>>)newValue, this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    @SafeVarargs
    public final AutoModRuleEditSpec withActions(AutoModActionData ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new AutoModRuleEditSpec(this.reason, this.name(), this.eventType(), this.triggerMetaData(), (Possible<List<AutoModActionData>>)newValue, this.enabled(), this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleEditSpec withEnabled(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new AutoModRuleEditSpec(this.reason, this.name(), this.eventType(), this.triggerMetaData(), this.actions(), newValue, this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleEditSpec withEnabled(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new AutoModRuleEditSpec(this.reason, this.name(), this.eventType(), this.triggerMetaData(), this.actions(), (Possible<Boolean>)newValue, this.exemptRoles(), this.exemptChannels());
    }

    public AutoModRuleEditSpec withExemptRoles(Possible<List<Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return new AutoModRuleEditSpec(this.reason, this.name(), this.eventType(), this.triggerMetaData(), this.actions(), this.enabled(), newValue, this.exemptChannels());
    }

    public AutoModRuleEditSpec withExemptRoles(Iterable<Snowflake> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new AutoModRuleEditSpec(this.reason, this.name(), this.eventType(), this.triggerMetaData(), this.actions(), this.enabled(), (Possible<List<Snowflake>>)newValue, this.exemptChannels());
    }

    @SafeVarargs
    public final AutoModRuleEditSpec withExemptRoles(Snowflake ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new AutoModRuleEditSpec(this.reason, this.name(), this.eventType(), this.triggerMetaData(), this.actions(), this.enabled(), (Possible<List<Snowflake>>)newValue, this.exemptChannels());
    }

    public AutoModRuleEditSpec withExemptChannels(Possible<List<Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return new AutoModRuleEditSpec(this.reason, this.name(), this.eventType(), this.triggerMetaData(), this.actions(), this.enabled(), this.exemptRoles(), newValue);
    }

    public AutoModRuleEditSpec withExemptChannels(Iterable<Snowflake> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new AutoModRuleEditSpec(this.reason, this.name(), this.eventType(), this.triggerMetaData(), this.actions(), this.enabled(), this.exemptRoles(), (Possible<List<Snowflake>>)newValue);
    }

    @SafeVarargs
    public final AutoModRuleEditSpec withExemptChannels(Snowflake ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new AutoModRuleEditSpec(this.reason, this.name(), this.eventType(), this.triggerMetaData(), this.actions(), this.enabled(), this.exemptRoles(), (Possible<List<Snowflake>>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AutoModRuleEditSpec && this.equalTo(0, (AutoModRuleEditSpec)another);
    }

    private boolean equalTo(int synthetic, AutoModRuleEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.eventType().equals(another.eventType()) && this.triggerMetaData().equals(another.triggerMetaData()) && Objects.equals(this.actions_value, another.actions_value) && this.enabled().equals(another.enabled()) && Objects.equals(this.exemptRoles_value, another.exemptRoles_value) && Objects.equals(this.exemptChannels_value, another.exemptChannels_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + this.eventType().hashCode();
        h += (h << 5) + this.triggerMetaData().hashCode();
        h += (h << 5) + Objects.hashCode(this.actions_value);
        h += (h << 5) + this.enabled().hashCode();
        h += (h << 5) + Objects.hashCode(this.exemptRoles_value);
        h += (h << 5) + Objects.hashCode(this.exemptChannels_value);
        return h;
    }

    public String toString() {
        return "AutoModRuleEditSpec{reason=" + this.reason + ", name=" + this.name().toString() + ", eventType=" + this.eventType().toString() + ", triggerMetaData=" + this.triggerMetaData().toString() + ", actions=" + Objects.toString(this.actions_value) + ", enabled=" + this.enabled().toString() + ", exemptRoles=" + Objects.toString(this.exemptRoles_value) + ", exemptChannels=" + Objects.toString(this.exemptChannels_value) + "}";
    }

    public static AutoModRuleEditSpec copyOf(AutoModRuleEditSpecGenerator instance) {
        if (instance instanceof AutoModRuleEditSpec) {
            return (AutoModRuleEditSpec)instance;
        }
        return AutoModRuleEditSpec.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isEventTypePresent() {
        return !this.eventType_absent;
    }

    public Integer eventTypeOrElse(Integer defaultValue) {
        return !this.eventType_absent ? this.eventType_value : defaultValue;
    }

    public boolean isTriggerMetaDataPresent() {
        return !this.triggerMetaData_absent;
    }

    public AutoModTriggerMetaData triggerMetaDataOrElse(AutoModTriggerMetaData defaultValue) {
        return !this.triggerMetaData_absent ? this.triggerMetaData_value : defaultValue;
    }

    public boolean isActionsPresent() {
        return !this.actions_absent;
    }

    public List<AutoModActionData> actionsOrElse(List<AutoModActionData> defaultValue) {
        return !this.actions_absent ? this.actions_value : defaultValue;
    }

    public boolean isEnabledPresent() {
        return !this.enabled_absent;
    }

    public Boolean enabledOrElse(Boolean defaultValue) {
        return !this.enabled_absent ? this.enabled_value : defaultValue;
    }

    public boolean isExemptRolesPresent() {
        return !this.exemptRoles_absent;
    }

    public List<Snowflake> exemptRolesOrElse(List<Snowflake> defaultValue) {
        return !this.exemptRoles_absent ? this.exemptRoles_value : defaultValue;
    }

    public boolean isExemptChannelsPresent() {
        return !this.exemptChannels_absent;
    }

    public List<Snowflake> exemptChannelsOrElse(List<Snowflake> defaultValue) {
        return !this.exemptChannels_absent ? this.exemptChannels_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private Possible<Integer> eventType_possible = Possible.absent();
        private Possible<AutoModTriggerMetaData> triggerMetaData_possible = Possible.absent();
        private List<AutoModActionData> actions_list = null;
        private Possible<Boolean> enabled_possible = Possible.absent();
        private List<Snowflake> exemptRoles_list = null;
        private List<Snowflake> exemptChannels_list = null;
        @Nullable
        private String reason;

        private Builder() {
        }

        public final Builder from(AutoModRuleEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.eventType(instance.eventType());
            this.triggerMetaData(instance.triggerMetaData());
            this.actions(instance.actions());
            this.enabled(instance.enabled());
            this.exemptRoles(instance.exemptRoles());
            this.exemptChannels(instance.exemptChannels());
            return this;
        }

        public final Builder reason(@reactor.util.annotation.Nullable String reason) {
            this.reason = reason;
            return this;
        }

        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        public Builder name(String value) {
            this.name_possible = Possible.of((Object)value);
            return this;
        }

        public Builder eventType(Possible<Integer> value) {
            this.eventType_possible = value;
            return this;
        }

        public Builder eventType(Integer value) {
            this.eventType_possible = Possible.of((Object)value);
            return this;
        }

        public Builder triggerMetaData(Possible<AutoModTriggerMetaData> value) {
            this.triggerMetaData_possible = value;
            return this;
        }

        public Builder triggerMetaData(AutoModTriggerMetaData value) {
            this.triggerMetaData_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addAction(AutoModActionData element) {
            this.actions_getOrCreate().add(element);
            return this;
        }

        public Builder addAllActions(List<AutoModActionData> elements) {
            this.actions_getOrCreate().addAll(elements);
            return this;
        }

        public Builder actions(Possible<List<AutoModActionData>> elements) {
            this.actions_list = null;
            elements.toOptional().ifPresent(e -> this.actions_getOrCreate().addAll((Collection<AutoModActionData>)e));
            return this;
        }

        public Builder actions(List<AutoModActionData> elements) {
            this.actions_list = new ArrayList<AutoModActionData>(elements);
            return this;
        }

        public Builder actions(Iterable<AutoModActionData> elements) {
            this.actions_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public Builder enabled(Possible<Boolean> value) {
            this.enabled_possible = value;
            return this;
        }

        public Builder enabled(Boolean value) {
            this.enabled_possible = Possible.of((Object)value);
            return this;
        }

        public Builder addExemptRole(Snowflake element) {
            this.exemptRoles_getOrCreate().add(element);
            return this;
        }

        public Builder addAllExemptRoles(List<Snowflake> elements) {
            this.exemptRoles_getOrCreate().addAll(elements);
            return this;
        }

        public Builder exemptRoles(Possible<List<Snowflake>> elements) {
            this.exemptRoles_list = null;
            elements.toOptional().ifPresent(e -> this.exemptRoles_getOrCreate().addAll((Collection<Snowflake>)e));
            return this;
        }

        public Builder exemptRoles(List<Snowflake> elements) {
            this.exemptRoles_list = new ArrayList<Snowflake>(elements);
            return this;
        }

        public Builder exemptRoles(Iterable<Snowflake> elements) {
            this.exemptRoles_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public Builder addExemptChannel(Snowflake element) {
            this.exemptChannels_getOrCreate().add(element);
            return this;
        }

        public Builder addAllExemptChannels(List<Snowflake> elements) {
            this.exemptChannels_getOrCreate().addAll(elements);
            return this;
        }

        public Builder exemptChannels(Possible<List<Snowflake>> elements) {
            this.exemptChannels_list = null;
            elements.toOptional().ifPresent(e -> this.exemptChannels_getOrCreate().addAll((Collection<Snowflake>)e));
            return this;
        }

        public Builder exemptChannels(List<Snowflake> elements) {
            this.exemptChannels_list = new ArrayList<Snowflake>(elements);
            return this;
        }

        public Builder exemptChannels(Iterable<Snowflake> elements) {
            this.exemptChannels_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public AutoModRuleEditSpec build() {
            return new AutoModRuleEditSpec(this.reason, this.name_build(), this.eventType_build(), this.triggerMetaData_build(), this.actions_build(), this.enabled_build(), this.exemptRoles_build(), this.exemptChannels_build());
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<Integer> eventType_build() {
            return this.eventType_possible;
        }

        private Possible<AutoModTriggerMetaData> triggerMetaData_build() {
            return this.triggerMetaData_possible;
        }

        private Possible<List<AutoModActionData>> actions_build() {
            return this.actions_list == null ? Possible.absent() : Possible.of(this.actions_list);
        }

        private List<AutoModActionData> actions_getOrCreate() {
            if (this.actions_list == null) {
                this.actions_list = new ArrayList<AutoModActionData>();
            }
            return this.actions_list;
        }

        private Possible<Boolean> enabled_build() {
            return this.enabled_possible;
        }

        private Possible<List<Snowflake>> exemptRoles_build() {
            return this.exemptRoles_list == null ? Possible.absent() : Possible.of(this.exemptRoles_list);
        }

        private List<Snowflake> exemptRoles_getOrCreate() {
            if (this.exemptRoles_list == null) {
                this.exemptRoles_list = new ArrayList<Snowflake>();
            }
            return this.exemptRoles_list;
        }

        private Possible<List<Snowflake>> exemptChannels_build() {
            return this.exemptChannels_list == null ? Possible.absent() : Possible.of(this.exemptChannels_list);
        }

        private List<Snowflake> exemptChannels_getOrCreate() {
            if (this.exemptChannels_list == null) {
                this.exemptChannels_list = new ArrayList<Snowflake>();
            }
            return this.exemptChannels_list;
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build AutoModRuleEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

