/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.audit.ActionType;
import discord4j.core.spec.AuditLogQuerySpecGenerator;
import java.util.Objects;
import javax.annotation.Nullable;

public final class AuditLogQuerySpec
implements AuditLogQuerySpecGenerator {
    @reactor.util.annotation.Nullable
    private final Snowflake userId;
    @reactor.util.annotation.Nullable
    private final ActionType actionType;
    @reactor.util.annotation.Nullable
    private final Snowflake before;
    @reactor.util.annotation.Nullable
    private final Integer limit;
    private static final AuditLogQuerySpec INSTANCE = AuditLogQuerySpec.validate(new AuditLogQuerySpec());

    private AuditLogQuerySpec() {
        this.userId = null;
        this.actionType = null;
        this.before = null;
        this.limit = null;
    }

    private AuditLogQuerySpec(@reactor.util.annotation.Nullable Snowflake userId, @reactor.util.annotation.Nullable ActionType actionType, @reactor.util.annotation.Nullable Snowflake before, @reactor.util.annotation.Nullable Integer limit) {
        this.userId = userId;
        this.actionType = actionType;
        this.before = before;
        this.limit = limit;
    }

    @Override
    @reactor.util.annotation.Nullable
    public Snowflake userId() {
        return this.userId;
    }

    @Override
    @reactor.util.annotation.Nullable
    public ActionType actionType() {
        return this.actionType;
    }

    @Override
    @reactor.util.annotation.Nullable
    public Snowflake before() {
        return this.before;
    }

    @Override
    @reactor.util.annotation.Nullable
    public Integer limit() {
        return this.limit;
    }

    public final AuditLogQuerySpec withUserId(@reactor.util.annotation.Nullable Snowflake value) {
        if (this.userId == value) {
            return this;
        }
        return AuditLogQuerySpec.validate(new AuditLogQuerySpec(value, this.actionType, this.before, this.limit));
    }

    public final AuditLogQuerySpec withActionType(@reactor.util.annotation.Nullable ActionType value) {
        if (this.actionType == value) {
            return this;
        }
        return AuditLogQuerySpec.validate(new AuditLogQuerySpec(this.userId, value, this.before, this.limit));
    }

    public final AuditLogQuerySpec withBefore(@reactor.util.annotation.Nullable Snowflake value) {
        if (this.before == value) {
            return this;
        }
        return AuditLogQuerySpec.validate(new AuditLogQuerySpec(this.userId, this.actionType, value, this.limit));
    }

    public final AuditLogQuerySpec withLimit(@reactor.util.annotation.Nullable Integer value) {
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return AuditLogQuerySpec.validate(new AuditLogQuerySpec(this.userId, this.actionType, this.before, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AuditLogQuerySpec && this.equalTo(0, (AuditLogQuerySpec)another);
    }

    private boolean equalTo(int synthetic, AuditLogQuerySpec another) {
        return Objects.equals(this.userId, another.userId) && Objects.equals((Object)this.actionType, (Object)another.actionType) && Objects.equals(this.before, another.before) && Objects.equals(this.limit, another.limit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.userId);
        h += (h << 5) + Objects.hashCode((Object)this.actionType);
        h += (h << 5) + Objects.hashCode(this.before);
        h += (h << 5) + Objects.hashCode(this.limit);
        return h;
    }

    public String toString() {
        return "AuditLogQuerySpec{userId=" + this.userId + ", actionType=" + (Object)((Object)this.actionType) + ", before=" + this.before + ", limit=" + this.limit + "}";
    }

    public static AuditLogQuerySpec create() {
        return INSTANCE;
    }

    private static AuditLogQuerySpec validate(AuditLogQuerySpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static AuditLogQuerySpec copyOf(AuditLogQuerySpecGenerator instance) {
        if (instance instanceof AuditLogQuerySpec) {
            return (AuditLogQuerySpec)instance;
        }
        return AuditLogQuerySpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private Snowflake userId;
        @Nullable
        private ActionType actionType;
        @Nullable
        private Snowflake before;
        @Nullable
        private Integer limit;

        private Builder() {
        }

        public final Builder from(AuditLogQuerySpec instance) {
            return this.from((AuditLogQuerySpecGenerator)instance);
        }

        final Builder from(AuditLogQuerySpecGenerator instance) {
            Integer limitValue;
            Snowflake beforeValue;
            ActionType actionTypeValue;
            Objects.requireNonNull(instance, "instance");
            Snowflake userIdValue = instance.userId();
            if (userIdValue != null) {
                this.userId(userIdValue);
            }
            if ((actionTypeValue = instance.actionType()) != null) {
                this.actionType(actionTypeValue);
            }
            if ((beforeValue = instance.before()) != null) {
                this.before(beforeValue);
            }
            if ((limitValue = instance.limit()) != null) {
                this.limit(limitValue);
            }
            return this;
        }

        public final Builder userId(@reactor.util.annotation.Nullable Snowflake userId) {
            this.userId = userId;
            return this;
        }

        public final Builder actionType(@reactor.util.annotation.Nullable ActionType actionType) {
            this.actionType = actionType;
            return this;
        }

        public final Builder before(@reactor.util.annotation.Nullable Snowflake before) {
            this.before = before;
            return this;
        }

        public final Builder limit(@reactor.util.annotation.Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public AuditLogQuerySpec build() {
            return AuditLogQuerySpec.validate(new AuditLogQuerySpec(this.userId, this.actionType, this.before, this.limit));
        }
    }
}

