/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.VoiceChannel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.VoiceStateData;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Mono;

public final class VoiceState
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final VoiceStateData data;

    public VoiceState(GatewayDiscordClient gateway, VoiceStateData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public VoiceStateData getData() {
        return this.data;
    }

    public Snowflake getGuildId() {
        return Snowflake.of((Id)((Id)this.data.guildId().toOptional().orElseThrow(IllegalStateException::new)));
    }

    public Mono<Guild> getGuild() {
        return this.gateway.getGuildById(this.getGuildId());
    }

    public Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getGuildById(this.getGuildId());
    }

    public Optional<Snowflake> getChannelId() {
        return this.data.channelId().map(Snowflake::of);
    }

    public Mono<VoiceChannel> getChannel() {
        return Mono.justOrEmpty(this.getChannelId()).flatMap(this.gateway::getChannelById).cast(VoiceChannel.class);
    }

    public Mono<VoiceChannel> getChannel(EntityRetrievalStrategy retrievalStrategy) {
        return Mono.justOrEmpty(this.getChannelId()).flatMap(id -> this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById((Snowflake)id)).cast(VoiceChannel.class);
    }

    public Snowflake getUserId() {
        return Snowflake.of((Id)this.data.userId());
    }

    public Mono<User> getUser() {
        return this.gateway.getUserById(this.getUserId());
    }

    public Mono<User> getUser(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getUserById(this.getUserId());
    }

    public Mono<Member> getMember() {
        return this.gateway.getMemberById(this.getGuildId(), this.getUserId());
    }

    public Mono<Member> getMember(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getMemberById(this.getGuildId(), this.getUserId());
    }

    public String getSessionId() {
        return this.data.sessionId();
    }

    public boolean isDeaf() {
        return this.data.deaf();
    }

    public boolean isMuted() {
        return this.data.mute();
    }

    public boolean isSelfDeaf() {
        return this.data.selfDeaf();
    }

    public boolean isSelfMuted() {
        return this.data.selfMute();
    }

    public boolean isSelfStreaming() {
        return this.data.selfStream().toOptional().orElse(false);
    }

    public boolean isSelfVideoEnabled() {
        return this.data.selfVideo();
    }

    public boolean isSuppressed() {
        return this.data.suppress();
    }

    public Optional<Instant> getRequestedToSpeakAt() {
        return this.data.requestToSpeakTimestamp().map(timestamp -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, Instant::from));
    }

    public String toString() {
        return "VoiceState{data=" + this.data + '}';
    }
}

