/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.guild;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.guild.GuildEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.ScheduledEvent;
import discord4j.core.object.entity.User;
import discord4j.gateway.ShardInfo;
import reactor.core.publisher.Mono;

public class ScheduledEventUserAddEvent
extends GuildEvent {
    private final long guildId;
    private final long scheduledEventId;
    private final long userId;

    public ScheduledEventUserAddEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, long guildId, long scheduledEventId, long userId) {
        super(gateway, shardInfo);
        this.guildId = guildId;
        this.scheduledEventId = scheduledEventId;
        this.userId = userId;
    }

    public Snowflake getGuildId() {
        return Snowflake.of((long)this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    public Snowflake getScheduledEventId() {
        return Snowflake.of((long)this.scheduledEventId);
    }

    public Mono<ScheduledEvent> getScheduledEvent() {
        return this.getClient().getScheduledEventById(this.getGuildId(), this.getScheduledEventId());
    }

    public Snowflake getUserId() {
        return Snowflake.of((long)this.userId);
    }

    public Mono<User> getUser() {
        return this.getClient().getUserById(this.getUserId());
    }

    public Mono<Member> getMember() {
        return this.getClient().getMemberById(this.getGuildId(), this.getUserId());
    }

    public String toString() {
        return "ScheduledEventUserAddEvent{guildId=" + this.guildId + ", scheduledEventId=" + this.scheduledEventId + ", userId=" + this.userId + "}";
    }
}

