/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.channel;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.channel.ChannelEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.gateway.ShardInfo;
import java.time.Instant;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class PinsUpdateEvent
extends ChannelEvent {
    private final long channelId;
    @Nullable
    private final Long guildId;
    @Nullable
    private final Instant lastPinTimestamp;

    public PinsUpdateEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, long channelId, @Nullable Long guildId, @Nullable Instant lastPinTimestamp) {
        super(gateway, shardInfo);
        this.channelId = channelId;
        this.guildId = guildId;
        this.lastPinTimestamp = lastPinTimestamp;
    }

    public Snowflake getChannelId() {
        return Snowflake.of((long)this.channelId);
    }

    public Mono<MessageChannel> getChannel() {
        return this.getClient().getChannelById(this.getChannelId()).cast(MessageChannel.class);
    }

    public Optional<Snowflake> getGuildId() {
        return Optional.ofNullable(this.guildId).map(Snowflake::of);
    }

    public Mono<Guild> getGuild() {
        return Mono.justOrEmpty(this.getGuildId()).flatMap(this.getClient()::getGuildById);
    }

    public Optional<Instant> getLastPinTimestamp() {
        return Optional.ofNullable(this.lastPinTimestamp);
    }

    public String toString() {
        return "PinsUpdateEvent{channelId=" + this.channelId + ", lastPinTimestamp=" + this.lastPinTimestamp + '}';
    }
}

