/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.Event;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.User;
import discord4j.core.object.presence.Presence;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.PartialUserData;
import discord4j.discordjson.possible.Possible;
import discord4j.gateway.ShardInfo;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class PresenceUpdateEvent
extends Event {
    private final long guildId;
    private final User oldUser;
    private final PartialUserData user;
    private final Presence current;
    private final Presence old;

    public PresenceUpdateEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, long guildId, @Nullable User oldUser, PartialUserData user, Presence current, @Nullable Presence old) {
        super(gateway, shardInfo);
        this.guildId = guildId;
        this.oldUser = oldUser;
        this.user = user;
        this.current = current;
        this.old = old;
    }

    public Snowflake getGuildId() {
        return Snowflake.of((long)this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    public Optional<User> getOldUser() {
        return Optional.ofNullable(this.oldUser);
    }

    public Optional<String> getNewGlobalName() {
        return Possible.flatOpt((Possible)this.user.globalName());
    }

    public Optional<String> getNewUsername() {
        return this.user.username().toOptional();
    }

    @Deprecated
    public Optional<String> getNewDiscriminator() {
        return this.user.discriminator().toOptional();
    }

    public Optional<String> getNewAvatar() {
        return Possible.flatOpt((Possible)this.user.avatar());
    }

    public Snowflake getUserId() {
        return Snowflake.of((Id)this.user.id());
    }

    public Mono<User> getUser() {
        return this.getClient().getUserById(this.getUserId());
    }

    public Mono<Member> getMember() {
        return this.getClient().getMemberById(this.getGuildId(), this.getUserId());
    }

    public Presence getCurrent() {
        return this.current;
    }

    public Optional<Presence> getOld() {
        return Optional.ofNullable(this.old);
    }

    public String toString() {
        return "PresenceUpdateEvent{guildId=" + this.guildId + ", oldUser=" + this.oldUser + ", user=" + this.user + ", current=" + this.current + ", old=" + this.old + '}';
    }
}

