/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.EntitlementData;
import discord4j.discordjson.json.gateway.EntitlementCreate;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableEntitlementCreate
implements EntitlementCreate {
    private final EntitlementData entitlement;

    private ImmutableEntitlementCreate(EntitlementData entitlement) {
        this.entitlement = Objects.requireNonNull(entitlement, "entitlement");
    }

    private ImmutableEntitlementCreate(ImmutableEntitlementCreate original, EntitlementData entitlement) {
        this.entitlement = entitlement;
    }

    @Override
    @JsonProperty(value="entitlement")
    @JsonUnwrapped
    public EntitlementData entitlement() {
        return this.entitlement;
    }

    public final ImmutableEntitlementCreate withEntitlement(EntitlementData value) {
        if (this.entitlement == value) {
            return this;
        }
        EntitlementData newValue = Objects.requireNonNull(value, "entitlement");
        return new ImmutableEntitlementCreate(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntitlementCreate && this.equalTo(0, (ImmutableEntitlementCreate)another);
    }

    private boolean equalTo(int synthetic, ImmutableEntitlementCreate another) {
        return this.entitlement.equals(another.entitlement);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.entitlement.hashCode();
        return h;
    }

    public String toString() {
        return "EntitlementCreate{entitlement=" + this.entitlement + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEntitlementCreate fromJson(Json json) {
        Builder builder = ImmutableEntitlementCreate.builder();
        if (json.entitlement != null) {
            builder.entitlement(json.entitlement);
        }
        return builder.build();
    }

    public static ImmutableEntitlementCreate of(EntitlementData entitlement) {
        return new ImmutableEntitlementCreate(entitlement);
    }

    public static ImmutableEntitlementCreate copyOf(EntitlementCreate instance) {
        if (instance instanceof ImmutableEntitlementCreate) {
            return (ImmutableEntitlementCreate)instance;
        }
        return ImmutableEntitlementCreate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ENTITLEMENT = 1L;
        private long initBits = 1L;
        @Nullable
        private EntitlementData entitlement;

        private Builder() {
        }

        public final Builder from(EntitlementCreate instance) {
            Objects.requireNonNull(instance, "instance");
            this.entitlement(instance.entitlement());
            return this;
        }

        @JsonProperty(value="entitlement")
        @JsonUnwrapped
        public final Builder entitlement(EntitlementData entitlement) {
            this.entitlement = Objects.requireNonNull(entitlement, "entitlement");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableEntitlementCreate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEntitlementCreate(null, this.entitlement);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("entitlement");
            }
            return "Cannot build EntitlementCreate, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements EntitlementCreate {
        @Nullable
        EntitlementData entitlement;

        Json() {
        }

        @JsonProperty(value="entitlement")
        @JsonUnwrapped
        public void setEntitlement(EntitlementData entitlement) {
            this.entitlement = entitlement;
        }

        @Override
        public EntitlementData entitlement() {
            throw new UnsupportedOperationException();
        }
    }
}

