/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.SkuData;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableSkuData
implements SkuData {
    private final long id_value;
    private final int type;
    private final long applicationId_value;
    private final String name;
    private final String slug;
    private final int flags;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableSkuData(Id id, int type, Id applicationId, String name, String slug, int flags) {
        Id id$impl = id;
        this.type = type;
        Id applicationId$impl = applicationId;
        this.name = Objects.requireNonNull(name, "name");
        this.slug = Objects.requireNonNull(slug, "slug");
        this.flags = flags;
        this.id_value = id$impl.asLong();
        this.applicationId_value = applicationId$impl.asLong();
        this.initShim = null;
    }

    private ImmutableSkuData(ImmutableSkuData original, Id id, int type, Id applicationId, String name, String slug, int flags) {
        Id id$impl = id;
        this.type = type;
        Id applicationId$impl = applicationId;
        this.name = name;
        this.slug = slug;
        this.flags = flags;
        this.id_value = id$impl.asLong();
        this.applicationId_value = applicationId$impl.asLong();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of((long)this.id_value);
    }

    @Override
    @JsonProperty(value="type")
    public int type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="application_id")
    public Id applicationId() {
        return Id.of((long)this.applicationId_value);
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="slug")
    public String slug() {
        return this.slug;
    }

    @Override
    @JsonProperty(value="flags")
    public int flags() {
        return this.flags;
    }

    public ImmutableSkuData withId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableSkuData(this, newValue, this.type, this.applicationId(), this.name, this.slug, this.flags);
    }

    public ImmutableSkuData withId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableSkuData(this, newValue, this.type, this.applicationId(), this.name, this.slug, this.flags);
    }

    public final ImmutableSkuData withType(int value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableSkuData(this, this.id(), value, this.applicationId(), this.name, this.slug, this.flags);
    }

    public ImmutableSkuData withApplicationId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableSkuData(this, this.id(), this.type, newValue, this.name, this.slug, this.flags);
    }

    public ImmutableSkuData withApplicationId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableSkuData(this, this.id(), this.type, newValue, this.name, this.slug, this.flags);
    }

    public final ImmutableSkuData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableSkuData(this, this.id(), this.type, this.applicationId(), newValue, this.slug, this.flags);
    }

    public final ImmutableSkuData withSlug(String value) {
        String newValue = Objects.requireNonNull(value, "slug");
        if (this.slug.equals(newValue)) {
            return this;
        }
        return new ImmutableSkuData(this, this.id(), this.type, this.applicationId(), this.name, newValue, this.flags);
    }

    public final ImmutableSkuData withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableSkuData(this, this.id(), this.type, this.applicationId(), this.name, this.slug, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSkuData && this.equalTo(0, (ImmutableSkuData)another);
    }

    private boolean equalTo(int synthetic, ImmutableSkuData another) {
        return Objects.equals(this.id_value, another.id_value) && this.type == another.type && Objects.equals(this.applicationId_value, another.applicationId_value) && this.name.equals(another.name) && this.slug.equals(another.slug) && this.flags == another.flags;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id_value);
        h += (h << 5) + this.type;
        h += (h << 5) + Objects.hashCode(this.applicationId_value);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.slug.hashCode();
        h += (h << 5) + this.flags;
        return h;
    }

    public String toString() {
        return "SkuData{id=" + Objects.toString(this.id_value) + ", type=" + this.type + ", applicationId=" + Objects.toString(this.applicationId_value) + ", name=" + this.name + ", slug=" + this.slug + ", flags=" + this.flags + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableSkuData fromJson(Json json) {
        Builder builder = ImmutableSkuData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.typeIsSet) {
            builder.type(json.type);
        }
        if (json.applicationId != null) {
            builder.applicationId(json.applicationId);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.slug != null) {
            builder.slug(json.slug);
        }
        if (json.flagsIsSet) {
            builder.flags(json.flags);
        }
        return builder.build();
    }

    public static ImmutableSkuData of(Id id, int type, Id applicationId, String name, String slug, int flags) {
        return new ImmutableSkuData(id, type, applicationId, name, slug, flags);
    }

    public static ImmutableSkuData copyOf(SkuData instance) {
        if (instance instanceof ImmutableSkuData) {
            return (ImmutableSkuData)instance;
        }
        return ImmutableSkuData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_SLUG = 4L;
        private static final long INIT_BIT_FLAGS = 8L;
        private long initBits = 15L;
        private Id id_id = null;
        private Id applicationId_id = null;
        private int type;
        @Nullable
        private String name;
        @Nullable
        private String slug;
        private int flags;

        private Builder() {
        }

        public final Builder from(SkuData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.type(instance.type());
            this.applicationId(instance.applicationId());
            this.name(instance.name());
            this.slug(instance.slug());
            this.flags(instance.flags());
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of((String)value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(int type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder applicationId(String value) {
            this.applicationId_id = Id.of((String)value);
            return this;
        }

        public Builder applicationId(long value) {
            this.applicationId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="application_id")
        public Builder applicationId(Id value) {
            this.applicationId_id = value;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="slug")
        public final Builder slug(String slug) {
            this.slug = Objects.requireNonNull(slug, "slug");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="flags")
        public final Builder flags(int flags) {
            this.flags = flags;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableSkuData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSkuData(null, this.id_build(), this.type, this.applicationId_build(), this.name, this.slug, this.flags);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("slug");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("flags");
            }
            return "Cannot build SkuData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }

        private Id applicationId_build() {
            return this.applicationId_id;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SkuData {
        @Nullable
        Id id;
        int type;
        boolean typeIsSet;
        @Nullable
        Id applicationId;
        @Nullable
        String name;
        @Nullable
        String slug;
        int flags;
        boolean flagsIsSet;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="type")
        public void setType(int type) {
            this.type = type;
            this.typeIsSet = true;
        }

        @JsonProperty(value="application_id")
        public void setApplicationId(Id applicationId) {
            this.applicationId = applicationId;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="slug")
        public void setSlug(String slug) {
            this.slug = slug;
        }

        @JsonProperty(value="flags")
        public void setFlags(int flags) {
            this.flags = flags;
            this.flagsIsSet = true;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id applicationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String slug() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int flags() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build SkuData, attribute initializers form cycle " + attributes;
        }
    }
}

