/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.RecurrenceRuleData;
import discord4j.discordjson.json.RecurrenceRuleNWeekdayData;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableRecurrenceRuleData
implements RecurrenceRuleData {
    private final Instant start;
    @Nullable
    private final Instant end;
    private final int frequency;
    private final int interval;
    @Nullable
    private final List<Integer> byWeekday;
    @Nullable
    private final List<RecurrenceRuleNWeekdayData> byNWeekday;
    @Nullable
    private final List<Integer> byMonth;
    @Nullable
    private final List<Integer> byMonthDay;
    @Nullable
    private final List<Integer> byYearDay;
    @Nullable
    private final Integer count;

    private ImmutableRecurrenceRuleData(Instant start, Optional<? extends Instant> end, int frequency, int interval, Optional<? extends List<Integer>> byWeekday, Optional<? extends List<RecurrenceRuleNWeekdayData>> byNWeekday, Optional<? extends List<Integer>> byMonth, Optional<? extends List<Integer>> byMonthDay, Optional<? extends List<Integer>> byYearDay, Optional<Integer> count) {
        this.start = Objects.requireNonNull(start, "start");
        this.end = end.orElse(null);
        this.frequency = frequency;
        this.interval = interval;
        this.byWeekday = byWeekday.orElse(null);
        this.byNWeekday = byNWeekday.orElse(null);
        this.byMonth = byMonth.orElse(null);
        this.byMonthDay = byMonthDay.orElse(null);
        this.byYearDay = byYearDay.orElse(null);
        this.count = count.orElse(null);
    }

    private ImmutableRecurrenceRuleData(ImmutableRecurrenceRuleData original, Instant start, @Nullable Instant end, int frequency, int interval, @Nullable List<Integer> byWeekday, @Nullable List<RecurrenceRuleNWeekdayData> byNWeekday, @Nullable List<Integer> byMonth, @Nullable List<Integer> byMonthDay, @Nullable List<Integer> byYearDay, @Nullable Integer count) {
        this.start = start;
        this.end = end;
        this.frequency = frequency;
        this.interval = interval;
        this.byWeekday = byWeekday;
        this.byNWeekday = byNWeekday;
        this.byMonth = byMonth;
        this.byMonthDay = byMonthDay;
        this.byYearDay = byYearDay;
        this.count = count;
    }

    @Override
    @JsonProperty(value="start")
    public Instant start() {
        return this.start;
    }

    @Override
    @JsonProperty(value="end")
    public Optional<Instant> end() {
        return Optional.ofNullable(this.end);
    }

    @Override
    @JsonProperty(value="frequency")
    public int frequency() {
        return this.frequency;
    }

    @Override
    @JsonProperty(value="interval")
    public int interval() {
        return this.interval;
    }

    @Override
    @JsonProperty(value="by_weekday")
    public Optional<List<Integer>> byWeekday() {
        return Optional.ofNullable(this.byWeekday);
    }

    @Override
    @JsonProperty(value="by_n_weekday")
    public Optional<List<RecurrenceRuleNWeekdayData>> byNWeekday() {
        return Optional.ofNullable(this.byNWeekday);
    }

    @Override
    @JsonProperty(value="by_month")
    public Optional<List<Integer>> byMonth() {
        return Optional.ofNullable(this.byMonth);
    }

    @Override
    @JsonProperty(value="by_month_day")
    public Optional<List<Integer>> byMonthDay() {
        return Optional.ofNullable(this.byMonthDay);
    }

    @Override
    @JsonProperty(value="by_year_day")
    public Optional<List<Integer>> byYearDay() {
        return Optional.ofNullable(this.byYearDay);
    }

    @Override
    @JsonProperty(value="count")
    public Optional<Integer> count() {
        return Optional.ofNullable(this.count);
    }

    public final ImmutableRecurrenceRuleData withStart(Instant value) {
        if (this.start == value) {
            return this;
        }
        Instant newValue = Objects.requireNonNull(value, "start");
        return new ImmutableRecurrenceRuleData(this, newValue, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final ImmutableRecurrenceRuleData withEnd(Instant value) {
        Instant newValue = Objects.requireNonNull(value, "end");
        if (this.end == newValue) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, newValue, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final ImmutableRecurrenceRuleData withEnd(Optional<? extends Instant> optional) {
        Instant value = optional.orElse(null);
        if (this.end == value) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, value, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final ImmutableRecurrenceRuleData withFrequency(int value) {
        if (this.frequency == value) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, this.end, value, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final ImmutableRecurrenceRuleData withInterval(int value) {
        if (this.interval == value) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, this.end, this.frequency, value, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final ImmutableRecurrenceRuleData withByWeekday(List<Integer> value) {
        List<Integer> newValue = Objects.requireNonNull(value, "byWeekday");
        if (this.byWeekday == newValue) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, this.end, this.frequency, this.interval, newValue, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final ImmutableRecurrenceRuleData withByWeekday(Optional<? extends List<Integer>> optional) {
        List value = optional.orElse(null);
        if (this.byWeekday == value) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, this.end, this.frequency, this.interval, value, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final ImmutableRecurrenceRuleData withByNWeekday(List<RecurrenceRuleNWeekdayData> value) {
        List<RecurrenceRuleNWeekdayData> newValue = Objects.requireNonNull(value, "byNWeekday");
        if (this.byNWeekday == newValue) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, this.end, this.frequency, this.interval, this.byWeekday, newValue, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final ImmutableRecurrenceRuleData withByNWeekday(Optional<? extends List<RecurrenceRuleNWeekdayData>> optional) {
        List value = optional.orElse(null);
        if (this.byNWeekday == value) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, this.end, this.frequency, this.interval, this.byWeekday, value, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
    }

    public final ImmutableRecurrenceRuleData withByMonth(List<Integer> value) {
        List<Integer> newValue = Objects.requireNonNull(value, "byMonth");
        if (this.byMonth == newValue) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, newValue, this.byMonthDay, this.byYearDay, this.count);
    }

    public final ImmutableRecurrenceRuleData withByMonth(Optional<? extends List<Integer>> optional) {
        List value = optional.orElse(null);
        if (this.byMonth == value) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, value, this.byMonthDay, this.byYearDay, this.count);
    }

    public final ImmutableRecurrenceRuleData withByMonthDay(List<Integer> value) {
        List<Integer> newValue = Objects.requireNonNull(value, "byMonthDay");
        if (this.byMonthDay == newValue) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, newValue, this.byYearDay, this.count);
    }

    public final ImmutableRecurrenceRuleData withByMonthDay(Optional<? extends List<Integer>> optional) {
        List value = optional.orElse(null);
        if (this.byMonthDay == value) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, value, this.byYearDay, this.count);
    }

    public final ImmutableRecurrenceRuleData withByYearDay(List<Integer> value) {
        List<Integer> newValue = Objects.requireNonNull(value, "byYearDay");
        if (this.byYearDay == newValue) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, newValue, this.count);
    }

    public final ImmutableRecurrenceRuleData withByYearDay(Optional<? extends List<Integer>> optional) {
        List value = optional.orElse(null);
        if (this.byYearDay == value) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, value, this.count);
    }

    public final ImmutableRecurrenceRuleData withCount(int value) {
        Integer newValue = value;
        if (Objects.equals(this.count, newValue)) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, newValue);
    }

    public final ImmutableRecurrenceRuleData withCount(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.count, value)) {
            return this;
        }
        return new ImmutableRecurrenceRuleData(this, this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRecurrenceRuleData && this.equalTo(0, (ImmutableRecurrenceRuleData)another);
    }

    private boolean equalTo(int synthetic, ImmutableRecurrenceRuleData another) {
        return this.start.equals(another.start) && Objects.equals(this.end, another.end) && this.frequency == another.frequency && this.interval == another.interval && Objects.equals(this.byWeekday, another.byWeekday) && Objects.equals(this.byNWeekday, another.byNWeekday) && Objects.equals(this.byMonth, another.byMonth) && Objects.equals(this.byMonthDay, another.byMonthDay) && Objects.equals(this.byYearDay, another.byYearDay) && Objects.equals(this.count, another.count);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.start.hashCode();
        h += (h << 5) + Objects.hashCode(this.end);
        h += (h << 5) + this.frequency;
        h += (h << 5) + this.interval;
        h += (h << 5) + Objects.hashCode(this.byWeekday);
        h += (h << 5) + Objects.hashCode(this.byNWeekday);
        h += (h << 5) + Objects.hashCode(this.byMonth);
        h += (h << 5) + Objects.hashCode(this.byMonthDay);
        h += (h << 5) + Objects.hashCode(this.byYearDay);
        h += (h << 5) + Objects.hashCode(this.count);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RecurrenceRuleData{");
        builder.append("start=").append(this.start);
        if (this.end != null) {
            builder.append(", ");
            builder.append("end=").append(this.end);
        }
        builder.append(", ");
        builder.append("frequency=").append(this.frequency);
        builder.append(", ");
        builder.append("interval=").append(this.interval);
        if (this.byWeekday != null) {
            builder.append(", ");
            builder.append("byWeekday=").append(this.byWeekday);
        }
        if (this.byNWeekday != null) {
            builder.append(", ");
            builder.append("byNWeekday=").append(this.byNWeekday);
        }
        if (this.byMonth != null) {
            builder.append(", ");
            builder.append("byMonth=").append(this.byMonth);
        }
        if (this.byMonthDay != null) {
            builder.append(", ");
            builder.append("byMonthDay=").append(this.byMonthDay);
        }
        if (this.byYearDay != null) {
            builder.append(", ");
            builder.append("byYearDay=").append(this.byYearDay);
        }
        if (this.count != null) {
            builder.append(", ");
            builder.append("count=").append(this.count);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRecurrenceRuleData fromJson(Json json) {
        Builder builder = ImmutableRecurrenceRuleData.builder();
        if (json.start != null) {
            builder.start(json.start);
        }
        if (json.end != null) {
            builder.end(json.end);
        }
        if (json.frequencyIsSet) {
            builder.frequency(json.frequency);
        }
        if (json.intervalIsSet) {
            builder.interval(json.interval);
        }
        if (json.byWeekday != null) {
            builder.byWeekday(json.byWeekday);
        }
        if (json.byNWeekday != null) {
            builder.byNWeekday(json.byNWeekday);
        }
        if (json.byMonth != null) {
            builder.byMonth(json.byMonth);
        }
        if (json.byMonthDay != null) {
            builder.byMonthDay(json.byMonthDay);
        }
        if (json.byYearDay != null) {
            builder.byYearDay(json.byYearDay);
        }
        if (json.count != null) {
            builder.count(json.count);
        }
        return builder.build();
    }

    public static ImmutableRecurrenceRuleData of(Instant start, Optional<? extends Instant> end, int frequency, int interval, Optional<? extends List<Integer>> byWeekday, Optional<? extends List<RecurrenceRuleNWeekdayData>> byNWeekday, Optional<? extends List<Integer>> byMonth, Optional<? extends List<Integer>> byMonthDay, Optional<? extends List<Integer>> byYearDay, Optional<Integer> count) {
        return new ImmutableRecurrenceRuleData(start, end, frequency, interval, byWeekday, byNWeekday, byMonth, byMonthDay, byYearDay, count);
    }

    public static ImmutableRecurrenceRuleData copyOf(RecurrenceRuleData instance) {
        if (instance instanceof ImmutableRecurrenceRuleData) {
            return (ImmutableRecurrenceRuleData)instance;
        }
        return ImmutableRecurrenceRuleData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_START = 1L;
        private static final long INIT_BIT_FREQUENCY = 2L;
        private static final long INIT_BIT_INTERVAL = 4L;
        private long initBits = 7L;
        @Nullable
        private Instant start;
        @Nullable
        private Instant end;
        private int frequency;
        private int interval;
        @Nullable
        private List<Integer> byWeekday;
        @Nullable
        private List<RecurrenceRuleNWeekdayData> byNWeekday;
        @Nullable
        private List<Integer> byMonth;
        @Nullable
        private List<Integer> byMonthDay;
        @Nullable
        private List<Integer> byYearDay;
        @Nullable
        private Integer count;

        private Builder() {
        }

        public final Builder from(RecurrenceRuleData instance) {
            Optional<Integer> countOptional;
            Optional<List<Integer>> byYearDayOptional;
            Optional<List<Integer>> byMonthDayOptional;
            Optional<List<Integer>> byMonthOptional;
            Optional<List<RecurrenceRuleNWeekdayData>> byNWeekdayOptional;
            Objects.requireNonNull(instance, "instance");
            this.start(instance.start());
            Optional<Instant> endOptional = instance.end();
            if (endOptional.isPresent()) {
                this.end(endOptional);
            }
            this.frequency(instance.frequency());
            this.interval(instance.interval());
            Optional<List<Integer>> byWeekdayOptional = instance.byWeekday();
            if (byWeekdayOptional.isPresent()) {
                this.byWeekday(byWeekdayOptional);
            }
            if ((byNWeekdayOptional = instance.byNWeekday()).isPresent()) {
                this.byNWeekday(byNWeekdayOptional);
            }
            if ((byMonthOptional = instance.byMonth()).isPresent()) {
                this.byMonth(byMonthOptional);
            }
            if ((byMonthDayOptional = instance.byMonthDay()).isPresent()) {
                this.byMonthDay(byMonthDayOptional);
            }
            if ((byYearDayOptional = instance.byYearDay()).isPresent()) {
                this.byYearDay(byYearDayOptional);
            }
            if ((countOptional = instance.count()).isPresent()) {
                this.count(countOptional);
            }
            return this;
        }

        @JsonProperty(value="start")
        public final Builder start(Instant start) {
            this.start = Objects.requireNonNull(start, "start");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder end(Instant end) {
            this.end = Objects.requireNonNull(end, "end");
            return this;
        }

        @JsonProperty(value="end")
        public final Builder end(Optional<? extends Instant> end) {
            this.end = end.orElse(null);
            return this;
        }

        @JsonProperty(value="frequency")
        public final Builder frequency(int frequency) {
            this.frequency = frequency;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="interval")
        public final Builder interval(int interval) {
            this.interval = interval;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder byWeekday(List<Integer> byWeekday) {
            this.byWeekday = Objects.requireNonNull(byWeekday, "byWeekday");
            return this;
        }

        @JsonProperty(value="by_weekday")
        public final Builder byWeekday(Optional<? extends List<Integer>> byWeekday) {
            this.byWeekday = byWeekday.orElse(null);
            return this;
        }

        public final Builder byNWeekday(List<RecurrenceRuleNWeekdayData> byNWeekday) {
            this.byNWeekday = Objects.requireNonNull(byNWeekday, "byNWeekday");
            return this;
        }

        @JsonProperty(value="by_n_weekday")
        public final Builder byNWeekday(Optional<? extends List<RecurrenceRuleNWeekdayData>> byNWeekday) {
            this.byNWeekday = byNWeekday.orElse(null);
            return this;
        }

        public final Builder byMonth(List<Integer> byMonth) {
            this.byMonth = Objects.requireNonNull(byMonth, "byMonth");
            return this;
        }

        @JsonProperty(value="by_month")
        public final Builder byMonth(Optional<? extends List<Integer>> byMonth) {
            this.byMonth = byMonth.orElse(null);
            return this;
        }

        public final Builder byMonthDay(List<Integer> byMonthDay) {
            this.byMonthDay = Objects.requireNonNull(byMonthDay, "byMonthDay");
            return this;
        }

        @JsonProperty(value="by_month_day")
        public final Builder byMonthDay(Optional<? extends List<Integer>> byMonthDay) {
            this.byMonthDay = byMonthDay.orElse(null);
            return this;
        }

        public final Builder byYearDay(List<Integer> byYearDay) {
            this.byYearDay = Objects.requireNonNull(byYearDay, "byYearDay");
            return this;
        }

        @JsonProperty(value="by_year_day")
        public final Builder byYearDay(Optional<? extends List<Integer>> byYearDay) {
            this.byYearDay = byYearDay.orElse(null);
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            return this;
        }

        @JsonProperty(value="count")
        public final Builder count(Optional<Integer> count) {
            this.count = count.orElse(null);
            return this;
        }

        public ImmutableRecurrenceRuleData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRecurrenceRuleData(null, this.start, this.end, this.frequency, this.interval, this.byWeekday, this.byNWeekday, this.byMonth, this.byMonthDay, this.byYearDay, this.count);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("start");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("frequency");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("interval");
            }
            return "Cannot build RecurrenceRuleData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements RecurrenceRuleData {
        @Nullable
        Instant start;
        @Nullable
        Optional<Instant> end = Optional.empty();
        int frequency;
        boolean frequencyIsSet;
        int interval;
        boolean intervalIsSet;
        @Nullable
        Optional<List<Integer>> byWeekday = Optional.empty();
        @Nullable
        Optional<List<RecurrenceRuleNWeekdayData>> byNWeekday = Optional.empty();
        @Nullable
        Optional<List<Integer>> byMonth = Optional.empty();
        @Nullable
        Optional<List<Integer>> byMonthDay = Optional.empty();
        @Nullable
        Optional<List<Integer>> byYearDay = Optional.empty();
        @Nullable
        Optional<Integer> count = Optional.empty();

        Json() {
        }

        @JsonProperty(value="start")
        public void setStart(Instant start) {
            this.start = start;
        }

        @JsonProperty(value="end")
        public void setEnd(Optional<Instant> end) {
            this.end = end;
        }

        @JsonProperty(value="frequency")
        public void setFrequency(int frequency) {
            this.frequency = frequency;
            this.frequencyIsSet = true;
        }

        @JsonProperty(value="interval")
        public void setInterval(int interval) {
            this.interval = interval;
            this.intervalIsSet = true;
        }

        @JsonProperty(value="by_weekday")
        public void setByWeekday(Optional<List<Integer>> byWeekday) {
            this.byWeekday = byWeekday;
        }

        @JsonProperty(value="by_n_weekday")
        public void setByNWeekday(Optional<List<RecurrenceRuleNWeekdayData>> byNWeekday) {
            this.byNWeekday = byNWeekday;
        }

        @JsonProperty(value="by_month")
        public void setByMonth(Optional<List<Integer>> byMonth) {
            this.byMonth = byMonth;
        }

        @JsonProperty(value="by_month_day")
        public void setByMonthDay(Optional<List<Integer>> byMonthDay) {
            this.byMonthDay = byMonthDay;
        }

        @JsonProperty(value="by_year_day")
        public void setByYearDay(Optional<List<Integer>> byYearDay) {
            this.byYearDay = byYearDay;
        }

        @JsonProperty(value="count")
        public void setCount(Optional<Integer> count) {
            this.count = count;
        }

        @Override
        public Instant start() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> end() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int frequency() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int interval() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<Integer>> byWeekday() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<RecurrenceRuleNWeekdayData>> byNWeekday() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<Integer>> byMonth() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<Integer>> byMonthDay() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<Integer>> byYearDay() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> count() {
            throw new UnsupportedOperationException();
        }
    }
}

