/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.ReactionCountDetailsData;
import discord4j.discordjson.json.ReactionData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableReactionData
implements ReactionData {
    private final int count;
    private final ReactionCountDetailsData countDetails;
    private final boolean me;
    private final boolean meBurst;
    private final EmojiData emoji;
    private final List<String> burstColors;

    private ImmutableReactionData(int count, ReactionCountDetailsData countDetails, boolean me, boolean meBurst, EmojiData emoji, Iterable<String> burstColors) {
        this.count = count;
        this.countDetails = Objects.requireNonNull(countDetails, "countDetails");
        this.me = me;
        this.meBurst = meBurst;
        this.emoji = Objects.requireNonNull(emoji, "emoji");
        this.burstColors = ImmutableReactionData.createUnmodifiableList(false, ImmutableReactionData.createSafeList(burstColors, true, false));
    }

    private ImmutableReactionData(ImmutableReactionData original, int count, ReactionCountDetailsData countDetails, boolean me, boolean meBurst, EmojiData emoji, List<String> burstColors) {
        this.count = count;
        this.countDetails = countDetails;
        this.me = me;
        this.meBurst = meBurst;
        this.emoji = emoji;
        this.burstColors = burstColors;
    }

    @Override
    @JsonProperty(value="count")
    public int count() {
        return this.count;
    }

    @Override
    @JsonProperty(value="count_details")
    public ReactionCountDetailsData countDetails() {
        return this.countDetails;
    }

    @Override
    @JsonProperty(value="me")
    public boolean me() {
        return this.me;
    }

    @Override
    @JsonProperty(value="me_burst")
    public boolean meBurst() {
        return this.meBurst;
    }

    @Override
    @JsonProperty(value="emoji")
    public EmojiData emoji() {
        return this.emoji;
    }

    @Override
    @JsonProperty(value="burst_colors")
    public List<String> burstColors() {
        return this.burstColors;
    }

    public final ImmutableReactionData withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableReactionData(this, value, this.countDetails, this.me, this.meBurst, this.emoji, this.burstColors);
    }

    public final ImmutableReactionData withCountDetails(ReactionCountDetailsData value) {
        if (this.countDetails == value) {
            return this;
        }
        ReactionCountDetailsData newValue = Objects.requireNonNull(value, "countDetails");
        return new ImmutableReactionData(this, this.count, newValue, this.me, this.meBurst, this.emoji, this.burstColors);
    }

    public final ImmutableReactionData withMe(boolean value) {
        if (this.me == value) {
            return this;
        }
        return new ImmutableReactionData(this, this.count, this.countDetails, value, this.meBurst, this.emoji, this.burstColors);
    }

    public final ImmutableReactionData withMeBurst(boolean value) {
        if (this.meBurst == value) {
            return this;
        }
        return new ImmutableReactionData(this, this.count, this.countDetails, this.me, value, this.emoji, this.burstColors);
    }

    public final ImmutableReactionData withEmoji(EmojiData value) {
        if (this.emoji == value) {
            return this;
        }
        EmojiData newValue = Objects.requireNonNull(value, "emoji");
        return new ImmutableReactionData(this, this.count, this.countDetails, this.me, this.meBurst, newValue, this.burstColors);
    }

    public final ImmutableReactionData withBurstColors(String ... elements) {
        List<String> newValue = ImmutableReactionData.createUnmodifiableList(false, ImmutableReactionData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableReactionData(this, this.count, this.countDetails, this.me, this.meBurst, this.emoji, newValue);
    }

    public final ImmutableReactionData withBurstColors(Iterable<String> elements) {
        if (this.burstColors == elements) {
            return this;
        }
        List<String> newValue = ImmutableReactionData.createUnmodifiableList(false, ImmutableReactionData.createSafeList(elements, true, false));
        return new ImmutableReactionData(this, this.count, this.countDetails, this.me, this.meBurst, this.emoji, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReactionData && this.equalTo(0, (ImmutableReactionData)another);
    }

    private boolean equalTo(int synthetic, ImmutableReactionData another) {
        return this.count == another.count && this.countDetails.equals(another.countDetails) && this.me == another.me && this.meBurst == another.meBurst && this.emoji.equals(another.emoji) && this.burstColors.equals(another.burstColors);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.count;
        h += (h << 5) + this.countDetails.hashCode();
        h += (h << 5) + Boolean.hashCode(this.me);
        h += (h << 5) + Boolean.hashCode(this.meBurst);
        h += (h << 5) + this.emoji.hashCode();
        h += (h << 5) + this.burstColors.hashCode();
        return h;
    }

    public String toString() {
        return "ReactionData{count=" + this.count + ", countDetails=" + this.countDetails + ", me=" + this.me + ", meBurst=" + this.meBurst + ", emoji=" + this.emoji + ", burstColors=" + this.burstColors + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableReactionData fromJson(Json json) {
        Builder builder = ImmutableReactionData.builder();
        if (json.countIsSet) {
            builder.count(json.count);
        }
        if (json.countDetails != null) {
            builder.countDetails(json.countDetails);
        }
        if (json.meIsSet) {
            builder.me(json.me);
        }
        if (json.meBurstIsSet) {
            builder.meBurst(json.meBurst);
        }
        if (json.emoji != null) {
            builder.emoji(json.emoji);
        }
        if (json.burstColors != null) {
            builder.addAllBurstColors(json.burstColors);
        }
        return builder.build();
    }

    public static ImmutableReactionData of(int count, ReactionCountDetailsData countDetails, boolean me, boolean meBurst, EmojiData emoji, List<String> burstColors) {
        return ImmutableReactionData.of(count, countDetails, me, meBurst, emoji, burstColors);
    }

    public static ImmutableReactionData of(int count, ReactionCountDetailsData countDetails, boolean me, boolean meBurst, EmojiData emoji, Iterable<String> burstColors) {
        return new ImmutableReactionData(count, countDetails, me, meBurst, emoji, burstColors);
    }

    public static ImmutableReactionData copyOf(ReactionData instance) {
        if (instance instanceof ImmutableReactionData) {
            return (ImmutableReactionData)instance;
        }
        return ImmutableReactionData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long INIT_BIT_COUNT_DETAILS = 2L;
        private static final long INIT_BIT_ME = 4L;
        private static final long INIT_BIT_ME_BURST = 8L;
        private static final long INIT_BIT_EMOJI = 16L;
        private long initBits = 31L;
        private int count;
        @Nullable
        private ReactionCountDetailsData countDetails;
        private boolean me;
        private boolean meBurst;
        @Nullable
        private EmojiData emoji;
        private List<String> burstColors = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(ReactionData instance) {
            Objects.requireNonNull(instance, "instance");
            this.count(instance.count());
            this.countDetails(instance.countDetails());
            this.me(instance.me());
            this.meBurst(instance.meBurst());
            this.emoji(instance.emoji());
            this.addAllBurstColors(instance.burstColors());
            return this;
        }

        @JsonProperty(value="count")
        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="count_details")
        public final Builder countDetails(ReactionCountDetailsData countDetails) {
            this.countDetails = Objects.requireNonNull(countDetails, "countDetails");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="me")
        public final Builder me(boolean me) {
            this.me = me;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="me_burst")
        public final Builder meBurst(boolean meBurst) {
            this.meBurst = meBurst;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="emoji")
        public final Builder emoji(EmojiData emoji) {
            this.emoji = Objects.requireNonNull(emoji, "emoji");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder addBurstColor(String element) {
            this.burstColors.add(Objects.requireNonNull(element, "burstColors element"));
            return this;
        }

        public final Builder addBurstColors(String ... elements) {
            for (String element : elements) {
                this.burstColors.add(Objects.requireNonNull(element, "burstColors element"));
            }
            return this;
        }

        @JsonProperty(value="burst_colors")
        public final Builder burstColors(Iterable<String> elements) {
            this.burstColors.clear();
            return this.addAllBurstColors(elements);
        }

        public final Builder addAllBurstColors(Iterable<String> elements) {
            for (String element : elements) {
                this.burstColors.add(Objects.requireNonNull(element, "burstColors element"));
            }
            return this;
        }

        public ImmutableReactionData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReactionData(null, this.count, this.countDetails, this.me, this.meBurst, this.emoji, ImmutableReactionData.createUnmodifiableList(true, this.burstColors));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("countDetails");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("me");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("meBurst");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("emoji");
            }
            return "Cannot build ReactionData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ReactionData {
        int count;
        boolean countIsSet;
        @Nullable
        ReactionCountDetailsData countDetails;
        boolean me;
        boolean meIsSet;
        boolean meBurst;
        boolean meBurstIsSet;
        @Nullable
        EmojiData emoji;
        @Nullable
        List<String> burstColors = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="count")
        public void setCount(int count) {
            this.count = count;
            this.countIsSet = true;
        }

        @JsonProperty(value="count_details")
        public void setCountDetails(ReactionCountDetailsData countDetails) {
            this.countDetails = countDetails;
        }

        @JsonProperty(value="me")
        public void setMe(boolean me) {
            this.me = me;
            this.meIsSet = true;
        }

        @JsonProperty(value="me_burst")
        public void setMeBurst(boolean meBurst) {
            this.meBurst = meBurst;
            this.meBurstIsSet = true;
        }

        @JsonProperty(value="emoji")
        public void setEmoji(EmojiData emoji) {
            this.emoji = emoji;
        }

        @JsonProperty(value="burst_colors")
        public void setBurstColors(List<String> burstColors) {
            this.burstColors = burstColors;
        }

        @Override
        public int count() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReactionCountDetailsData countDetails() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean me() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean meBurst() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EmojiData emoji() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> burstColors() {
            throw new UnsupportedOperationException();
        }
    }
}

