/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.EntitlementData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ImmutableEntitlementData
implements EntitlementData {
    private final long id_value;
    private final long skuId_value;
    private final long applicationId_value;
    private final long userId_value;
    private final boolean userId_absent;
    private final int type;
    private final boolean deleted;
    private final long guildId_value;
    private final boolean guildId_absent;
    private final Boolean consumed_value;
    private final boolean consumed_absent;
    private final String startsAt_value;
    private final boolean startsAt_absent;
    private final String endsAt_value;
    private final boolean endsAt_absent;
    private final long subscriptionId_value;
    private final boolean subscriptionId_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableEntitlementData(Id id, Id skuId, Id applicationId, Possible<Id> userId, int type, boolean deleted, Possible<Id> guildId, Possible<Boolean> consumed, Possible<String> startsAt, Possible<Optional<String>> endsAt, Possible<Id> subscriptionId) {
        Id id$impl = id;
        Id skuId$impl = skuId;
        Id applicationId$impl = applicationId;
        Possible<Id> userId$impl = userId;
        this.type = type;
        this.deleted = deleted;
        Possible<Id> guildId$impl = guildId;
        Possible<Boolean> consumed$impl = consumed;
        Possible<String> startsAt$impl = startsAt;
        Possible<Optional<String>> endsAt$impl = endsAt;
        Possible<Id> subscriptionId$impl = subscriptionId;
        this.id_value = id$impl.asLong();
        this.skuId_value = skuId$impl.asLong();
        this.applicationId_value = applicationId$impl.asLong();
        this.userId_value = userId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.userId_absent = userId$impl.isAbsent();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.consumed_value = consumed$impl.toOptional().orElse(null);
        this.consumed_absent = consumed$impl.isAbsent();
        this.startsAt_value = startsAt$impl.toOptional().orElse(null);
        this.startsAt_absent = startsAt$impl.isAbsent();
        this.endsAt_value = Possible.flatOpt(endsAt$impl).orElse(null);
        this.endsAt_absent = endsAt$impl.isAbsent();
        this.subscriptionId_value = subscriptionId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.subscriptionId_absent = subscriptionId$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableEntitlementData(ImmutableEntitlementData original, Id id, Id skuId, Id applicationId, Possible<Id> userId, int type, boolean deleted, Possible<Id> guildId, Possible<Boolean> consumed, Possible<String> startsAt, Possible<Optional<String>> endsAt, Possible<Id> subscriptionId) {
        Id id$impl = id;
        Id skuId$impl = skuId;
        Id applicationId$impl = applicationId;
        Possible<Id> userId$impl = userId;
        this.type = type;
        this.deleted = deleted;
        Possible<Id> guildId$impl = guildId;
        Possible<Boolean> consumed$impl = consumed;
        Possible<String> startsAt$impl = startsAt;
        Possible<Optional<String>> endsAt$impl = endsAt;
        Possible<Id> subscriptionId$impl = subscriptionId;
        this.id_value = id$impl.asLong();
        this.skuId_value = skuId$impl.asLong();
        this.applicationId_value = applicationId$impl.asLong();
        this.userId_value = userId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.userId_absent = userId$impl.isAbsent();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.consumed_value = consumed$impl.toOptional().orElse(null);
        this.consumed_absent = consumed$impl.isAbsent();
        this.startsAt_value = startsAt$impl.toOptional().orElse(null);
        this.startsAt_absent = startsAt$impl.isAbsent();
        this.endsAt_value = Possible.flatOpt(endsAt$impl).orElse(null);
        this.endsAt_absent = endsAt$impl.isAbsent();
        this.subscriptionId_value = subscriptionId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.subscriptionId_absent = subscriptionId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of((long)this.id_value);
    }

    @Override
    @JsonProperty(value="sku_id")
    public Id skuId() {
        return Id.of((long)this.skuId_value);
    }

    @Override
    @JsonProperty(value="application_id")
    public Id applicationId() {
        return Id.of((long)this.applicationId_value);
    }

    @Override
    @JsonProperty(value="user_id")
    public Possible<Id> userId() {
        return this.userId_absent ? Possible.absent() : Possible.of((Object)Id.of((long)this.userId_value));
    }

    @Override
    @JsonProperty(value="type")
    public int type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="deleted")
    public boolean deleted() {
        return this.deleted;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Possible<Id> guildId() {
        return this.guildId_absent ? Possible.absent() : Possible.of((Object)Id.of((long)this.guildId_value));
    }

    @Override
    @JsonProperty(value="consumed")
    public Possible<Boolean> consumed() {
        return this.consumed_absent ? Possible.absent() : Possible.of((Object)this.consumed_value);
    }

    @Override
    @JsonProperty(value="starts_at")
    public Possible<String> startsAt() {
        return this.startsAt_absent ? Possible.absent() : Possible.of((Object)this.startsAt_value);
    }

    @Override
    @JsonProperty(value="ends_at")
    public Possible<Optional<String>> endsAt() {
        return this.endsAt_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.endsAt_value));
    }

    @Override
    @JsonProperty(value="subscription_id")
    public Possible<Id> subscriptionId() {
        return this.subscriptionId_absent ? Possible.absent() : Possible.of((Object)Id.of((long)this.subscriptionId_value));
    }

    public ImmutableEntitlementData withId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableEntitlementData(this, newValue, this.skuId(), this.applicationId(), this.userId(), this.type, this.deleted, this.guildId(), this.consumed(), this.startsAt(), this.endsAt(), this.subscriptionId());
    }

    public ImmutableEntitlementData withId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableEntitlementData(this, newValue, this.skuId(), this.applicationId(), this.userId(), this.type, this.deleted, this.guildId(), this.consumed(), this.startsAt(), this.endsAt(), this.subscriptionId());
    }

    public ImmutableEntitlementData withSkuId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableEntitlementData(this, this.id(), newValue, this.applicationId(), this.userId(), this.type, this.deleted, this.guildId(), this.consumed(), this.startsAt(), this.endsAt(), this.subscriptionId());
    }

    public ImmutableEntitlementData withSkuId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableEntitlementData(this, this.id(), newValue, this.applicationId(), this.userId(), this.type, this.deleted, this.guildId(), this.consumed(), this.startsAt(), this.endsAt(), this.subscriptionId());
    }

    public ImmutableEntitlementData withApplicationId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), newValue, this.userId(), this.type, this.deleted, this.guildId(), this.consumed(), this.startsAt(), this.endsAt(), this.subscriptionId());
    }

    public ImmutableEntitlementData withApplicationId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), newValue, this.userId(), this.type, this.deleted, this.guildId(), this.consumed(), this.startsAt(), this.endsAt(), this.subscriptionId());
    }

    public ImmutableEntitlementData withUserId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), this.applicationId(), newValue, this.type, this.deleted, this.guildId(), this.consumed(), this.startsAt(), this.endsAt(), this.subscriptionId());
    }

    public ImmutableEntitlementData withUserId(long value) {
        Possible newValue = Possible.of((Object)Id.of((long)value));
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), this.applicationId(), (Possible<Id>)newValue, this.type, this.deleted, this.guildId(), this.consumed(), this.startsAt(), this.endsAt(), this.subscriptionId());
    }

    public final ImmutableEntitlementData withType(int value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), this.applicationId(), this.userId(), value, this.deleted, this.guildId(), this.consumed(), this.startsAt(), this.endsAt(), this.subscriptionId());
    }

    public final ImmutableEntitlementData withDeleted(boolean value) {
        if (this.deleted == value) {
            return this;
        }
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), this.applicationId(), this.userId(), this.type, value, this.guildId(), this.consumed(), this.startsAt(), this.endsAt(), this.subscriptionId());
    }

    public ImmutableEntitlementData withGuildId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), this.applicationId(), this.userId(), this.type, this.deleted, newValue, this.consumed(), this.startsAt(), this.endsAt(), this.subscriptionId());
    }

    public ImmutableEntitlementData withGuildId(long value) {
        Possible newValue = Possible.of((Object)Id.of((long)value));
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), this.applicationId(), this.userId(), this.type, this.deleted, (Possible<Id>)newValue, this.consumed(), this.startsAt(), this.endsAt(), this.subscriptionId());
    }

    public ImmutableEntitlementData withConsumed(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), this.applicationId(), this.userId(), this.type, this.deleted, this.guildId(), newValue, this.startsAt(), this.endsAt(), this.subscriptionId());
    }

    public ImmutableEntitlementData withConsumed(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), this.applicationId(), this.userId(), this.type, this.deleted, this.guildId(), (Possible<Boolean>)newValue, this.startsAt(), this.endsAt(), this.subscriptionId());
    }

    public ImmutableEntitlementData withStartsAt(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), this.applicationId(), this.userId(), this.type, this.deleted, this.guildId(), this.consumed(), newValue, this.endsAt(), this.subscriptionId());
    }

    public ImmutableEntitlementData withStartsAt(String value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), this.applicationId(), this.userId(), this.type, this.deleted, this.guildId(), this.consumed(), (Possible<String>)newValue, this.endsAt(), this.subscriptionId());
    }

    public ImmutableEntitlementData withEndsAt(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), this.applicationId(), this.userId(), this.type, this.deleted, this.guildId(), this.consumed(), this.startsAt(), newValue, this.subscriptionId());
    }

    @Deprecated
    public ImmutableEntitlementData withEndsAt(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), this.applicationId(), this.userId(), this.type, this.deleted, this.guildId(), this.consumed(), this.startsAt(), (Possible<Optional<String>>)newValue, this.subscriptionId());
    }

    public ImmutableEntitlementData withEndsAtOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), this.applicationId(), this.userId(), this.type, this.deleted, this.guildId(), this.consumed(), this.startsAt(), (Possible<Optional<String>>)newValue, this.subscriptionId());
    }

    public ImmutableEntitlementData withSubscriptionId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), this.applicationId(), this.userId(), this.type, this.deleted, this.guildId(), this.consumed(), this.startsAt(), this.endsAt(), newValue);
    }

    public ImmutableEntitlementData withSubscriptionId(long value) {
        Possible newValue = Possible.of((Object)Id.of((long)value));
        return new ImmutableEntitlementData(this, this.id(), this.skuId(), this.applicationId(), this.userId(), this.type, this.deleted, this.guildId(), this.consumed(), this.startsAt(), this.endsAt(), (Possible<Id>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntitlementData && this.equalTo(0, (ImmutableEntitlementData)another);
    }

    private boolean equalTo(int synthetic, ImmutableEntitlementData another) {
        return Objects.equals(this.id_value, another.id_value) && Objects.equals(this.skuId_value, another.skuId_value) && Objects.equals(this.applicationId_value, another.applicationId_value) && this.userId().equals(another.userId()) && this.type == another.type && this.deleted == another.deleted && this.guildId().equals(another.guildId()) && this.consumed().equals(another.consumed()) && this.startsAt().equals(another.startsAt()) && this.endsAt().equals(another.endsAt()) && this.subscriptionId().equals(another.subscriptionId());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id_value);
        h += (h << 5) + Objects.hashCode(this.skuId_value);
        h += (h << 5) + Objects.hashCode(this.applicationId_value);
        h += (h << 5) + this.userId().hashCode();
        h += (h << 5) + this.type;
        h += (h << 5) + Boolean.hashCode(this.deleted);
        h += (h << 5) + this.guildId().hashCode();
        h += (h << 5) + this.consumed().hashCode();
        h += (h << 5) + this.startsAt().hashCode();
        h += (h << 5) + this.endsAt().hashCode();
        h += (h << 5) + this.subscriptionId().hashCode();
        return h;
    }

    public String toString() {
        return "EntitlementData{id=" + Objects.toString(this.id_value) + ", skuId=" + Objects.toString(this.skuId_value) + ", applicationId=" + Objects.toString(this.applicationId_value) + ", userId=" + this.userId().toString() + ", type=" + this.type + ", deleted=" + this.deleted + ", guildId=" + this.guildId().toString() + ", consumed=" + this.consumed().toString() + ", startsAt=" + this.startsAt().toString() + ", endsAt=" + this.endsAt().toString() + ", subscriptionId=" + this.subscriptionId().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEntitlementData fromJson(Json json) {
        Builder builder = ImmutableEntitlementData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.skuId != null) {
            builder.skuId(json.skuId);
        }
        if (json.applicationId != null) {
            builder.applicationId(json.applicationId);
        }
        if (json.userId != null) {
            builder.userId(json.userId);
        }
        if (json.typeIsSet) {
            builder.type(json.type);
        }
        if (json.deletedIsSet) {
            builder.deleted(json.deleted);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.consumed != null) {
            builder.consumed(json.consumed);
        }
        if (json.startsAt != null) {
            builder.startsAt(json.startsAt);
        }
        if (json.endsAt != null) {
            builder.endsAt(json.endsAt);
        }
        if (json.subscriptionId != null) {
            builder.subscriptionId(json.subscriptionId);
        }
        return builder.build();
    }

    public static ImmutableEntitlementData of(Id id, Id skuId, Id applicationId, Possible<Id> userId, int type, boolean deleted, Possible<Id> guildId, Possible<Boolean> consumed, Possible<String> startsAt, Possible<Optional<String>> endsAt, Possible<Id> subscriptionId) {
        return new ImmutableEntitlementData(id, skuId, applicationId, userId, type, deleted, guildId, consumed, startsAt, endsAt, subscriptionId);
    }

    public static ImmutableEntitlementData copyOf(EntitlementData instance) {
        if (instance instanceof ImmutableEntitlementData) {
            return (ImmutableEntitlementData)instance;
        }
        return ImmutableEntitlementData.builder().from(instance).build();
    }

    public boolean isUserIdPresent() {
        return !this.userId_absent;
    }

    public long userIdOrElse(long defaultValue) {
        return !this.userId_absent ? this.userId_value : defaultValue;
    }

    public boolean isGuildIdPresent() {
        return !this.guildId_absent;
    }

    public long guildIdOrElse(long defaultValue) {
        return !this.guildId_absent ? this.guildId_value : defaultValue;
    }

    public boolean isConsumedPresent() {
        return !this.consumed_absent;
    }

    public Boolean consumedOrElse(Boolean defaultValue) {
        return !this.consumed_absent ? this.consumed_value : defaultValue;
    }

    public boolean isStartsAtPresent() {
        return !this.startsAt_absent;
    }

    public String startsAtOrElse(String defaultValue) {
        return !this.startsAt_absent ? this.startsAt_value : defaultValue;
    }

    public boolean isEndsAtPresent() {
        return !this.endsAt_absent;
    }

    public String endsAtOrElse(String defaultValue) {
        return !this.endsAt_absent ? this.endsAt_value : defaultValue;
    }

    public boolean isSubscriptionIdPresent() {
        return !this.subscriptionId_absent;
    }

    public long subscriptionIdOrElse(long defaultValue) {
        return !this.subscriptionId_absent ? this.subscriptionId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_DELETED = 2L;
        private long initBits = 3L;
        private Id id_id = null;
        private Id skuId_id = null;
        private Id applicationId_id = null;
        private Possible<Id> userId_possible = Possible.absent();
        private Possible<Id> guildId_possible = Possible.absent();
        private Possible<Boolean> consumed_possible = Possible.absent();
        private Possible<String> startsAt_possible = Possible.absent();
        private Possible<Optional<String>> endsAt_possible = Possible.absent();
        private Possible<Id> subscriptionId_possible = Possible.absent();
        private int type;
        private boolean deleted;

        private Builder() {
        }

        public final Builder from(EntitlementData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.skuId(instance.skuId());
            this.applicationId(instance.applicationId());
            this.userId(instance.userId());
            this.type(instance.type());
            this.deleted(instance.deleted());
            this.guildId(instance.guildId());
            this.consumed(instance.consumed());
            this.startsAt(instance.startsAt());
            this.endsAt(instance.endsAt());
            this.subscriptionId(instance.subscriptionId());
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of((String)value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        public Builder skuId(String value) {
            this.skuId_id = Id.of((String)value);
            return this;
        }

        public Builder skuId(long value) {
            this.skuId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="sku_id")
        public Builder skuId(Id value) {
            this.skuId_id = value;
            return this;
        }

        public Builder applicationId(String value) {
            this.applicationId_id = Id.of((String)value);
            return this;
        }

        public Builder applicationId(long value) {
            this.applicationId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="application_id")
        public Builder applicationId(Id value) {
            this.applicationId_id = value;
            return this;
        }

        public Builder userId(String value) {
            this.userId_possible = Possible.of((Object)Id.of((String)value));
            return this;
        }

        public Builder userId(long value) {
            this.userId_possible = Possible.of((Object)Id.of((long)value));
            return this;
        }

        public Builder userId(Id value) {
            this.userId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="user_id")
        public Builder userId(Possible<Id> value) {
            this.userId_possible = value;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(int type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="deleted")
        public final Builder deleted(boolean deleted) {
            this.deleted = deleted;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_possible = Possible.of((Object)Id.of((String)value));
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_possible = Possible.of((Object)Id.of((long)value));
            return this;
        }

        public Builder guildId(Id value) {
            this.guildId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Possible<Id> value) {
            this.guildId_possible = value;
            return this;
        }

        @JsonProperty(value="consumed")
        public Builder consumed(Possible<Boolean> value) {
            this.consumed_possible = value;
            return this;
        }

        public Builder consumed(Boolean value) {
            this.consumed_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="starts_at")
        public Builder startsAt(Possible<String> value) {
            this.startsAt_possible = value;
            return this;
        }

        public Builder startsAt(String value) {
            this.startsAt_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="ends_at")
        public Builder endsAt(Possible<Optional<String>> value) {
            this.endsAt_possible = value;
            return this;
        }

        @Deprecated
        public Builder endsAt(@Nullable String value) {
            this.endsAt_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder endsAtOrNull(@Nullable String value) {
            this.endsAt_possible = Possible.of(Optional.ofNullable(value));
            return this;
        }

        public Builder subscriptionId(String value) {
            this.subscriptionId_possible = Possible.of((Object)Id.of((String)value));
            return this;
        }

        public Builder subscriptionId(long value) {
            this.subscriptionId_possible = Possible.of((Object)Id.of((long)value));
            return this;
        }

        public Builder subscriptionId(Id value) {
            this.subscriptionId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="subscription_id")
        public Builder subscriptionId(Possible<Id> value) {
            this.subscriptionId_possible = value;
            return this;
        }

        public ImmutableEntitlementData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEntitlementData(null, this.id_build(), this.skuId_build(), this.applicationId_build(), this.userId_build(), this.type, this.deleted, this.guildId_build(), this.consumed_build(), this.startsAt_build(), this.endsAt_build(), this.subscriptionId_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("deleted");
            }
            return "Cannot build EntitlementData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }

        private Id skuId_build() {
            return this.skuId_id;
        }

        private Id applicationId_build() {
            return this.applicationId_id;
        }

        private Possible<Id> userId_build() {
            return this.userId_possible;
        }

        private Possible<Id> guildId_build() {
            return this.guildId_possible;
        }

        private Possible<Boolean> consumed_build() {
            return this.consumed_possible;
        }

        private Possible<String> startsAt_build() {
            return this.startsAt_possible;
        }

        private Possible<Optional<String>> endsAt_build() {
            return this.endsAt_possible;
        }

        private Possible<Id> subscriptionId_build() {
            return this.subscriptionId_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements EntitlementData {
        @Nullable
        Id id;
        @Nullable
        Id skuId;
        @Nullable
        Id applicationId;
        Possible<Id> userId = Possible.absent();
        int type;
        boolean typeIsSet;
        boolean deleted;
        boolean deletedIsSet;
        Possible<Id> guildId = Possible.absent();
        Possible<Boolean> consumed = Possible.absent();
        Possible<String> startsAt = Possible.absent();
        Possible<Optional<String>> endsAt = Possible.absent();
        Possible<Id> subscriptionId = Possible.absent();

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="sku_id")
        public void setSkuId(Id skuId) {
            this.skuId = skuId;
        }

        @JsonProperty(value="application_id")
        public void setApplicationId(Id applicationId) {
            this.applicationId = applicationId;
        }

        @JsonProperty(value="user_id")
        public void setUserId(Possible<Id> userId) {
            this.userId = userId;
        }

        @JsonProperty(value="type")
        public void setType(int type) {
            this.type = type;
            this.typeIsSet = true;
        }

        @JsonProperty(value="deleted")
        public void setDeleted(boolean deleted) {
            this.deleted = deleted;
            this.deletedIsSet = true;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Possible<Id> guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="consumed")
        public void setConsumed(Possible<Boolean> consumed) {
            this.consumed = consumed;
        }

        @JsonProperty(value="starts_at")
        public void setStartsAt(Possible<String> startsAt) {
            this.startsAt = startsAt;
        }

        @JsonProperty(value="ends_at")
        public void setEndsAt(Possible<Optional<String>> endsAt) {
            this.endsAt = endsAt;
        }

        @JsonProperty(value="subscription_id")
        public void setSubscriptionId(Possible<Id> subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id skuId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id applicationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> userId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean deleted() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> consumed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<String> startsAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Optional<String>> endsAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> subscriptionId() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build EntitlementData, attribute initializers form cycle " + attributes;
        }
    }
}

