/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.EmbedFieldData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableEmbedFieldData
implements EmbedFieldData {
    private final String name;
    private final String value;
    private final Boolean inline_value;
    private final boolean inline_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableEmbedFieldData(String name, String value, Possible<Boolean> inline) {
        this.name = Objects.requireNonNull(name, "name");
        this.value = Objects.requireNonNull(value, "value");
        Possible<Boolean> inline$impl = inline;
        this.inline_value = inline$impl.toOptional().orElse(null);
        this.inline_absent = inline$impl.isAbsent();
        this.initShim = null;
    }

    private ImmutableEmbedFieldData(ImmutableEmbedFieldData original, String name, String value, Possible<Boolean> inline) {
        this.name = name;
        this.value = value;
        Possible<Boolean> inline$impl = inline;
        this.inline_value = inline$impl.toOptional().orElse(null);
        this.inline_absent = inline$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="value")
    public String value() {
        return this.value;
    }

    @Override
    @JsonProperty(value="inline")
    public Possible<Boolean> inline() {
        return this.inline_absent ? Possible.absent() : Possible.of((Object)this.inline_value);
    }

    public final ImmutableEmbedFieldData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableEmbedFieldData(this, newValue, this.value, this.inline());
    }

    public final ImmutableEmbedFieldData withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ImmutableEmbedFieldData(this, this.name, newValue, this.inline());
    }

    public ImmutableEmbedFieldData withInline(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableEmbedFieldData(this, this.name, this.value, newValue);
    }

    public ImmutableEmbedFieldData withInline(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableEmbedFieldData(this, this.name, this.value, (Possible<Boolean>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEmbedFieldData && this.equalTo(0, (ImmutableEmbedFieldData)another);
    }

    private boolean equalTo(int synthetic, ImmutableEmbedFieldData another) {
        return this.name.equals(another.name) && this.value.equals(another.value) && this.inline().equals(another.inline());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.inline().hashCode();
        return h;
    }

    public String toString() {
        return "EmbedFieldData{name=" + this.name + ", value=" + this.value + ", inline=" + this.inline().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEmbedFieldData fromJson(Json json) {
        Builder builder = ImmutableEmbedFieldData.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.value != null) {
            builder.value(json.value);
        }
        if (json.inline != null) {
            builder.inline(json.inline);
        }
        return builder.build();
    }

    public static ImmutableEmbedFieldData of(String name, String value, Possible<Boolean> inline) {
        return new ImmutableEmbedFieldData(name, value, inline);
    }

    public static ImmutableEmbedFieldData copyOf(EmbedFieldData instance) {
        if (instance instanceof ImmutableEmbedFieldData) {
            return (ImmutableEmbedFieldData)instance;
        }
        return ImmutableEmbedFieldData.builder().from(instance).build();
    }

    public boolean isInlinePresent() {
        return !this.inline_absent;
    }

    public Boolean inlineOrElse(Boolean defaultValue) {
        return !this.inline_absent ? this.inline_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        private Possible<Boolean> inline_possible = Possible.absent();
        @Nullable
        private String name;
        @Nullable
        private String value;

        private Builder() {
        }

        public final Builder from(EmbedFieldData instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.value(instance.value());
            this.inline(instance.inline());
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="value")
        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="inline")
        public Builder inline(Possible<Boolean> value) {
            this.inline_possible = value;
            return this;
        }

        public Builder inline(Boolean value) {
            this.inline_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableEmbedFieldData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEmbedFieldData(null, this.name, this.value, this.inline_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build EmbedFieldData, some of required attributes are not set " + attributes;
        }

        private Possible<Boolean> inline_build() {
            return this.inline_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements EmbedFieldData {
        @Nullable
        String name;
        @Nullable
        String value;
        Possible<Boolean> inline = Possible.absent();

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="value")
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="inline")
        public void setInline(Possible<Boolean> inline) {
            this.inline = inline;
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String value() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> inline() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build EmbedFieldData, attribute initializers form cycle " + attributes;
        }
    }
}

