/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.service;

import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.TemplateCreateGuildRequest;
import discord4j.discordjson.json.TemplateCreateRequest;
import discord4j.discordjson.json.TemplateData;
import discord4j.discordjson.json.TemplateModifyRequest;
import discord4j.rest.request.Router;
import discord4j.rest.route.Routes;
import discord4j.rest.service.RestService;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TemplateService
extends RestService {
    public TemplateService(Router router) {
        super(router);
    }

    public Mono<TemplateData> getTemplate(String templateCode) {
        return Routes.GUILD_TEMPLATE_GET.newRequest(templateCode).exchange(this.getRouter()).bodyToMono(TemplateData.class);
    }

    public Mono<GuildData> createGuild(String templateCode, TemplateCreateGuildRequest request) {
        return Routes.TEMPLATE_GUILD_CREATE.newRequest(templateCode).body(request).exchange(this.getRouter()).bodyToMono(GuildData.class);
    }

    public Flux<TemplateData> getTemplates(long guildId) {
        return Routes.GUILD_TEMPLATE_LIST_GET.newRequest(guildId).exchange(this.getRouter()).bodyToMono(TemplateData[].class).flatMapMany(Flux::fromArray);
    }

    public Mono<TemplateData> createTemplate(long guildId, TemplateCreateRequest request) {
        return Routes.GUILD_TEMPLATE_CREATE.newRequest(guildId).body(request).exchange(this.getRouter()).bodyToMono(TemplateData.class);
    }

    public Mono<TemplateData> syncTemplate(long guildId, String templateCode) {
        return Routes.GUILD_TEMPLATE_SYNC.newRequest(guildId, templateCode).exchange(this.getRouter()).bodyToMono(TemplateData.class);
    }

    public Mono<TemplateData> modifyTemplate(long guildId, String templateCode, TemplateModifyRequest request) {
        return Routes.GUILD_TEMPLATE_MODIFY.newRequest(guildId, templateCode).body(request).exchange(this.getRouter()).bodyToMono(TemplateData.class);
    }

    public Mono<TemplateData> deleteTemplate(long guildId, String templateCode) {
        return Routes.GUILD_TEMPLATE_DELETE.newRequest(guildId, templateCode).exchange(this.getRouter()).bodyToMono(TemplateData.class);
    }
}

