/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.interaction;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.InteractionData;
import discord4j.discordjson.json.MemberData;
import discord4j.rest.RestClient;
import discord4j.rest.entity.RestMember;
import discord4j.rest.entity.RestRole;
import discord4j.rest.interaction.InteractionMember;
import discord4j.rest.util.PermissionSet;
import java.util.Set;
import java.util.stream.Collectors;

class InteractionMemberOperations
implements InteractionMember {
    final RestClient restClient;
    final InteractionData interactionData;

    InteractionMemberOperations(RestClient restClient, InteractionData interactionData) {
        this.restClient = restClient;
        this.interactionData = interactionData;
    }

    @Override
    public MemberData getMemberData() {
        return (MemberData)this.interactionData.member().get();
    }

    @Override
    public Snowflake getGuildId() {
        return Snowflake.of((Id)((Id)this.interactionData.guildId().get()));
    }

    @Override
    public Snowflake getUserId() {
        return Snowflake.of((Id)this.getMemberData().user().id());
    }

    @Override
    public Set<RestRole> getRoles() {
        return this.getMemberData().roles().stream().map(id -> RestRole.create(this.restClient, this.getGuildId(), Snowflake.of((Id)id))).collect(Collectors.toSet());
    }

    @Override
    public PermissionSet getPermissions() {
        return PermissionSet.of(Long.parseLong((String)this.getMemberData().permissions().get()));
    }

    @Override
    public RestMember asRestMember() {
        return RestMember.create(this.restClient, this.getGuildId(), this.getUserId());
    }
}

