/*
 * Decompiled with CFR 0.152.
 */
package discord4j.voice;

import discord4j.voice.DefaultVoiceGatewayClient;
import discord4j.voice.VoiceConnection;
import discord4j.voice.VoiceConnectionFactory;
import discord4j.voice.VoiceGatewayOptions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;

public class DefaultVoiceConnectionFactory
implements VoiceConnectionFactory {
    private static final Logger log = Loggers.getLogger(DefaultVoiceConnectionFactory.class);
    private final Map<Long, Mono<VoiceConnection>> onHandshake = new ConcurrentHashMap<Long, Mono<VoiceConnection>>();

    @Override
    public Mono<VoiceConnection> create(VoiceGatewayOptions options) {
        return Mono.defer(() -> this.onHandshake.compute(options.getGuildId().asLong(), (id, existing) -> {
            if (existing != null) {
                log.debug("Concurrent handshake detected for guild {}: returning existing", new Object[]{id});
                return existing;
            }
            return Mono.usingWhen((Publisher)new DefaultVoiceGatewayClient(options).start(options.getVoiceServerOptions(), options.getSession()).publish(mono -> mono.flatMap(vc -> vc.onConnectOrDisconnect().thenReturn(vc)).doFinally(signal -> this.onHandshake.remove(options.getGuildId().asLong()))), Mono::just, vc -> Mono.empty(), (vc, t) -> vc.disconnect(), VoiceConnection::disconnect);
        }));
    }
}

