/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec.legacy;

import discord4j.common.util.Snowflake;
import discord4j.core.spec.legacy.LegacyAuditSpec;
import discord4j.discordjson.json.GuildMemberModifyRequest;
import discord4j.discordjson.json.ImmutableGuildMemberModifyRequest;
import discord4j.discordjson.possible.Possible;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class LegacyGuildMemberEditSpec
implements LegacyAuditSpec<GuildMemberModifyRequest> {
    private final ImmutableGuildMemberModifyRequest.Builder builder = GuildMemberModifyRequest.builder();
    @Nullable
    private String reason;

    public LegacyGuildMemberEditSpec setNewVoiceChannel(@Nullable Snowflake channel) {
        this.builder.channelId(Possible.of(Optional.ofNullable(channel).map(Snowflake::asString)));
        return this;
    }

    public LegacyGuildMemberEditSpec setMute(boolean mute) {
        this.builder.mute(Boolean.valueOf(mute));
        return this;
    }

    public LegacyGuildMemberEditSpec setDeafen(boolean deaf) {
        this.builder.deaf(Boolean.valueOf(deaf));
        return this;
    }

    public LegacyGuildMemberEditSpec setNickname(@Nullable String nickname) {
        this.builder.nickOrNull(nickname);
        return this;
    }

    public LegacyGuildMemberEditSpec setRoles(Set<Snowflake> roles) {
        this.builder.roles(roles.stream().map(Snowflake::asString).collect(Collectors.toList()));
        return this;
    }

    public LegacyGuildMemberEditSpec setReason(@Nullable String reason) {
        this.reason = reason;
        return this;
    }

    @Override
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public GuildMemberModifyRequest asRequest() {
        return this.builder.build();
    }
}

