/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.component.BaseMessageComponent;
import discord4j.core.object.component.TopLevelMessageComponent;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.EmbedCreateSpecGenerator;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.Spec;
import discord4j.discordjson.json.ImmutableWebhookMessageEditRequest;
import discord4j.discordjson.json.WebhookMessageEditRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import discord4j.rest.util.MultipartRequest;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.immutables.value.Value;

@Value.Immutable(singleton=true)
public interface WebhookMessageEditSpecGenerator
extends Spec<MultipartRequest<WebhookMessageEditRequest>> {
    public Possible<Optional<String>> content();

    @Value.Default
    default public List<MessageCreateFields.File> files() {
        return Collections.emptyList();
    }

    @Value.Default
    default public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        return Collections.emptyList();
    }

    @Value.Default
    default public List<EmbedCreateSpec> embeds() {
        return Collections.emptyList();
    }

    public Possible<Optional<AllowedMentions>> allowedMentions();

    public Possible<List<TopLevelMessageComponent>> components();

    public Possible<Snowflake> threadId();

    @Override
    default public MultipartRequest<WebhookMessageEditRequest> asRequest() {
        ImmutableWebhookMessageEditRequest request = WebhookMessageEditRequest.builder().content(this.content()).embeds(this.embeds().stream().map(EmbedCreateSpecGenerator::asRequest).collect(Collectors.toList())).allowedMentions(InternalSpecUtils.mapPossibleOptional(this.allowedMentions(), AllowedMentions::toData)).components(InternalSpecUtils.mapPossible(this.components(), components -> components.stream().map(BaseMessageComponent::getData).collect(Collectors.toList()))).build();
        return MultipartRequest.ofRequestAndFiles((Object)request, Stream.concat(this.files().stream(), this.fileSpoilers().stream()).map(MessageCreateFields.File::asRequest).collect(Collectors.toList()));
    }
}

