/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.spec.GuildEmojiCreateSpecGenerator;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class GuildEmojiCreateSpec
implements GuildEmojiCreateSpecGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final String name;
    private final Image image;
    private final List<Snowflake> roles;

    private GuildEmojiCreateSpec(String name, Image image) {
        this.name = Objects.requireNonNull(name, "name");
        this.image = Objects.requireNonNull(image, "image");
        this.reason = null;
        this.roles = GuildEmojiCreateSpec.createUnmodifiableList(false, GuildEmojiCreateSpec.createSafeList(GuildEmojiCreateSpecGenerator.super.roles(), true, false));
    }

    private GuildEmojiCreateSpec(Builder builder) {
        this.reason = builder.reason;
        this.name = builder.name;
        this.image = builder.image;
        this.roles = builder.rolesIsSet() ? GuildEmojiCreateSpec.createUnmodifiableList(true, builder.roles) : GuildEmojiCreateSpec.createUnmodifiableList(false, GuildEmojiCreateSpec.createSafeList(GuildEmojiCreateSpecGenerator.super.roles(), true, false));
    }

    private GuildEmojiCreateSpec(@reactor.util.annotation.Nullable String reason, String name, Image image, List<Snowflake> roles) {
        this.reason = reason;
        this.name = name;
        this.image = image;
        this.roles = roles;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Image image() {
        return this.image;
    }

    @Override
    public List<Snowflake> roles() {
        return this.roles;
    }

    public final GuildEmojiCreateSpec withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new GuildEmojiCreateSpec(value, this.name, this.image, this.roles);
    }

    public final GuildEmojiCreateSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new GuildEmojiCreateSpec(this.reason, newValue, this.image, this.roles);
    }

    public final GuildEmojiCreateSpec withImage(Image value) {
        if (this.image == value) {
            return this;
        }
        Image newValue = Objects.requireNonNull(value, "image");
        return new GuildEmojiCreateSpec(this.reason, this.name, newValue, this.roles);
    }

    public final GuildEmojiCreateSpec withRoles(Snowflake ... elements) {
        List<Snowflake> newValue = GuildEmojiCreateSpec.createUnmodifiableList(false, GuildEmojiCreateSpec.createSafeList(Arrays.asList(elements), true, false));
        return new GuildEmojiCreateSpec(this.reason, this.name, this.image, newValue);
    }

    public final GuildEmojiCreateSpec withRoles(Iterable<? extends Snowflake> elements) {
        if (this.roles == elements) {
            return this;
        }
        List<Snowflake> newValue = GuildEmojiCreateSpec.createUnmodifiableList(false, GuildEmojiCreateSpec.createSafeList(elements, true, false));
        return new GuildEmojiCreateSpec(this.reason, this.name, this.image, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildEmojiCreateSpec && this.equalTo(0, (GuildEmojiCreateSpec)another);
    }

    private boolean equalTo(int synthetic, GuildEmojiCreateSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name.equals(another.name) && this.image.equals((Object)another.image) && this.roles.equals(another.roles);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.image.hashCode();
        h += (h << 5) + this.roles.hashCode();
        return h;
    }

    public String toString() {
        return "GuildEmojiCreateSpec{reason=" + this.reason + ", name=" + this.name + ", image=" + this.image + ", roles=" + this.roles + "}";
    }

    public static GuildEmojiCreateSpec of(String name, Image image) {
        return new GuildEmojiCreateSpec(name, image);
    }

    static GuildEmojiCreateSpec copyOf(GuildEmojiCreateSpecGenerator instance) {
        if (instance instanceof GuildEmojiCreateSpec) {
            return (GuildEmojiCreateSpec)instance;
        }
        return GuildEmojiCreateSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_IMAGE = 2L;
        private static final long OPT_BIT_ROLES = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String reason;
        @Nullable
        private String name;
        @Nullable
        private Image image;
        private List<Snowflake> roles = new ArrayList<Snowflake>();

        private Builder() {
        }

        public final Builder from(GuildEmojiCreateSpec instance) {
            return this.from((GuildEmojiCreateSpecGenerator)instance);
        }

        final Builder from(GuildEmojiCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.image(instance.image());
            this.addAllRoles(instance.roles());
            return this;
        }

        public final Builder reason(@reactor.util.annotation.Nullable String reason) {
            this.reason = reason;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder image(Image image) {
            this.image = Objects.requireNonNull(image, "image");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addRole(Snowflake element) {
            this.roles.add(Objects.requireNonNull(element, "roles element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addRoles(Snowflake ... elements) {
            for (Snowflake element : elements) {
                this.roles.add(Objects.requireNonNull(element, "roles element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder roles(Iterable<? extends Snowflake> elements) {
            this.roles.clear();
            return this.addAllRoles(elements);
        }

        public final Builder addAllRoles(Iterable<? extends Snowflake> elements) {
            for (Snowflake snowflake : elements) {
                this.roles.add(Objects.requireNonNull(snowflake, "roles element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public GuildEmojiCreateSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new GuildEmojiCreateSpec(this);
        }

        private boolean rolesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("image");
            }
            return "Cannot build GuildEmojiCreateSpec, some of required attributes are not set " + attributes;
        }
    }
}

