/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.BanQuerySpecGenerator;
import java.util.Objects;
import javax.annotation.Nullable;

public final class BanQuerySpec
implements BanQuerySpecGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    @reactor.util.annotation.Nullable
    private final Integer deleteMessageSeconds;
    @reactor.util.annotation.Nullable
    private final Integer deleteMessageDays;
    private static final BanQuerySpec INSTANCE = BanQuerySpec.validate(new BanQuerySpec());

    private BanQuerySpec() {
        this.reason = null;
        this.deleteMessageSeconds = null;
        this.deleteMessageDays = null;
    }

    private BanQuerySpec(@reactor.util.annotation.Nullable String reason, @reactor.util.annotation.Nullable Integer deleteMessageSeconds, @reactor.util.annotation.Nullable Integer deleteMessageDays) {
        this.reason = reason;
        this.deleteMessageSeconds = deleteMessageSeconds;
        this.deleteMessageDays = deleteMessageDays;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    @reactor.util.annotation.Nullable
    public Integer deleteMessageSeconds() {
        return this.deleteMessageSeconds;
    }

    @Override
    @Deprecated
    @reactor.util.annotation.Nullable
    public Integer deleteMessageDays() {
        return this.deleteMessageDays;
    }

    public final BanQuerySpec withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return BanQuerySpec.validate(new BanQuerySpec(value, this.deleteMessageSeconds, this.deleteMessageDays));
    }

    public final BanQuerySpec withDeleteMessageSeconds(@reactor.util.annotation.Nullable Integer value) {
        if (Objects.equals(this.deleteMessageSeconds, value)) {
            return this;
        }
        return BanQuerySpec.validate(new BanQuerySpec(this.reason, value, this.deleteMessageDays));
    }

    @Deprecated
    public final BanQuerySpec withDeleteMessageDays(@reactor.util.annotation.Nullable Integer value) {
        if (Objects.equals(this.deleteMessageDays, value)) {
            return this;
        }
        return BanQuerySpec.validate(new BanQuerySpec(this.reason, this.deleteMessageSeconds, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BanQuerySpec && this.equalTo(0, (BanQuerySpec)another);
    }

    private boolean equalTo(int synthetic, BanQuerySpec another) {
        return Objects.equals(this.reason, another.reason) && Objects.equals(this.deleteMessageSeconds, another.deleteMessageSeconds) && Objects.equals(this.deleteMessageDays, another.deleteMessageDays);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + Objects.hashCode(this.deleteMessageSeconds);
        h += (h << 5) + Objects.hashCode(this.deleteMessageDays);
        return h;
    }

    public String toString() {
        return "BanQuerySpec{reason=" + this.reason + ", deleteMessageSeconds=" + this.deleteMessageSeconds + ", deleteMessageDays=" + this.deleteMessageDays + "}";
    }

    public static BanQuerySpec create() {
        return INSTANCE;
    }

    private static BanQuerySpec validate(BanQuerySpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static BanQuerySpec copyOf(BanQuerySpecGenerator instance) {
        if (instance instanceof BanQuerySpec) {
            return (BanQuerySpec)instance;
        }
        return BanQuerySpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private String reason;
        @Nullable
        private Integer deleteMessageSeconds;
        @Nullable
        private Integer deleteMessageDays;

        private Builder() {
        }

        public final Builder from(BanQuerySpec instance) {
            return this.from((BanQuerySpecGenerator)instance);
        }

        final Builder from(BanQuerySpecGenerator instance) {
            Integer deleteMessageDaysValue;
            Integer deleteMessageSecondsValue;
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            if ((deleteMessageSecondsValue = instance.deleteMessageSeconds()) != null) {
                this.deleteMessageSeconds(deleteMessageSecondsValue);
            }
            if ((deleteMessageDaysValue = instance.deleteMessageDays()) != null) {
                this.deleteMessageDays(deleteMessageDaysValue);
            }
            return this;
        }

        public final Builder reason(@reactor.util.annotation.Nullable String reason) {
            this.reason = reason;
            return this;
        }

        public final Builder deleteMessageSeconds(@reactor.util.annotation.Nullable Integer deleteMessageSeconds) {
            this.deleteMessageSeconds = deleteMessageSeconds;
            return this;
        }

        @Deprecated
        public final Builder deleteMessageDays(@reactor.util.annotation.Nullable Integer deleteMessageDays) {
            this.deleteMessageDays = deleteMessageDays;
            return this;
        }

        public BanQuerySpec build() {
            return BanQuerySpec.validate(new BanQuerySpec(this.reason, this.deleteMessageSeconds, this.deleteMessageDays));
        }
    }
}

