/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.onboarding;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.onboarding.OnboardingPromptOption;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.OnboardingPromptData;
import discord4j.discordjson.json.OnboardingPromptOptionData;
import java.util.List;
import java.util.stream.Collectors;

public class OnboardingPrompt
implements Entity {
    private final GatewayDiscordClient client;
    private final OnboardingPromptData data;
    private final Snowflake id;
    private final Type type;
    private final List<OnboardingPromptOption> options;

    public OnboardingPrompt(GatewayDiscordClient client, OnboardingPromptData data) {
        this.client = client;
        this.data = data;
        this.id = Snowflake.of((Id)data.id());
        this.type = Type.from(this.data.type());
        this.options = data.options().stream().map(promptOptionData -> new OnboardingPromptOption(client, (OnboardingPromptOptionData)promptOptionData)).collect(Collectors.toList());
    }

    public OnboardingPromptData getData() {
        return this.data;
    }

    public Type getType() {
        return this.type;
    }

    public List<OnboardingPromptOption> getOptions() {
        return this.options;
    }

    public String getTitle() {
        return this.data.title();
    }

    public boolean isSingleSelect() {
        return this.data.singleSelect();
    }

    public boolean isRequired() {
        return this.data.required();
    }

    public boolean isInOnboarding() {
        return this.data.inOnboarding();
    }

    @Override
    public Snowflake getId() {
        return this.id;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.client;
    }

    public String toString() {
        return "OnboardingPrompt{id=" + this.id + ", type=" + (Object)((Object)this.type) + ", options=" + this.options + '}';
    }

    public static enum Type {
        UNKNOWN(-1),
        MULTIPLE_CHOICE(0),
        DROPDOWN(1);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type from(int value) {
            switch (value) {
                case 0: {
                    return MULTIPLE_CHOICE;
                }
                case 1: {
                    return DROPDOWN;
                }
            }
            return UNKNOWN;
        }
    }
}

