/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.channel.BaseTopLevelGuildMessageChannel;
import discord4j.core.spec.TextChannelEditMono;
import discord4j.core.spec.TextChannelEditSpec;
import discord4j.core.spec.legacy.LegacyTextChannelEditSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.ChannelData;
import java.util.Objects;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

public final class TextChannel
extends BaseTopLevelGuildMessageChannel {
    public TextChannel(GatewayDiscordClient gateway, ChannelData data) {
        super(gateway, data);
    }

    @Override
    public int getRateLimitPerUser() {
        return (Integer)this.getData().rateLimitPerUser().toOptional().orElseThrow(IllegalStateException::new);
    }

    public boolean isNsfw() {
        return this.getData().nsfw().toOptional().orElse(false);
    }

    @Deprecated
    public Mono<TextChannel> edit(Consumer<? super LegacyTextChannelEditSpec> spec) {
        return Mono.defer(() -> {
            LegacyTextChannelEditSpec mutatedSpec = new LegacyTextChannelEditSpec();
            spec.accept(mutatedSpec);
            return this.getClient().getRestClient().getChannelService().modifyChannel(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(bean -> EntityUtil.getChannel(this.getClient(), bean)).cast(TextChannel.class);
    }

    public TextChannelEditMono edit() {
        return TextChannelEditMono.of(this);
    }

    public Mono<TextChannel> edit(TextChannelEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.getClient().getRestClient().getChannelService().modifyChannel(this.getId().asLong(), spec.asRequest(), spec.reason())).map(bean -> EntityUtil.getChannel(this.getClient(), bean)).cast(TextChannel.class);
    }

    @Override
    public String toString() {
        return "TextChannel{} " + super.toString();
    }
}

