/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.ApplicationInstallParams;
import discord4j.core.object.ApplicationIntegrationTypeConfiguration;
import discord4j.core.object.ApplicationRoleConnectionMetadata;
import discord4j.core.object.command.ApplicationIntegrationType;
import discord4j.core.object.entity.ApplicationEmoji;
import discord4j.core.object.entity.ApplicationTeam;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.User;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.ApplicationEditMono;
import discord4j.core.spec.ApplicationEditSpec;
import discord4j.core.spec.ApplicationEmojiCreateMono;
import discord4j.core.spec.ApplicationEmojiCreateSpec;
import discord4j.core.util.EntityUtil;
import discord4j.core.util.ImageUtil;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ApplicationEmojiDataList;
import discord4j.discordjson.json.ApplicationInfoData;
import discord4j.discordjson.json.ApplicationIntegrationTypeConfigurationData;
import discord4j.discordjson.json.ApplicationRoleConnectionMetadataData;
import discord4j.discordjson.json.ApplicationTeamData;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class ApplicationInfo
implements Entity {
    private static final String ICON_IMAGE_PATH = "app-icons/%s/%s";
    private static final String STORE_URL_SCHEME = "https://discord.com/application-directory/%s/store";
    private final GatewayDiscordClient gateway;
    private final ApplicationInfoData data;

    public ApplicationInfo(GatewayDiscordClient gateway, ApplicationInfoData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    public ApplicationInfoData getData() {
        return this.data;
    }

    public String getName() {
        return this.data.name();
    }

    public Optional<String> getIconUrl(Image.Format format) {
        return this.data.icon().map(icon -> ImageUtil.getUrl(String.format(ICON_IMAGE_PATH, this.getId().asString(), icon), format));
    }

    public Mono<Image> getIcon(Image.Format format) {
        return Mono.justOrEmpty(this.getIconUrl(format)).flatMap(Image::ofUrl);
    }

    public Optional<String> getCoverImageUrl(Image.Format format) {
        return this.data.coverImage().toOptional().map(icon -> ImageUtil.getUrl(String.format(ICON_IMAGE_PATH, this.getId().asString(), icon), format));
    }

    public Mono<Image> getCoverImage(Image.Format format) {
        return Mono.justOrEmpty(this.getCoverImageUrl(format)).flatMap(Image::ofUrl);
    }

    public String getDescription() {
        return this.data.description();
    }

    public List<String> getRpcOrigins() {
        return this.data.rpcOrigins().toOptional().orElse(Collections.emptyList());
    }

    @Deprecated
    public boolean isPublic() {
        return this.data.botPublic();
    }

    public boolean isBotPublic() {
        return this.data.botPublic();
    }

    @Deprecated
    public boolean requireCodeGrant() {
        return this.data.botRequireCodeGrant();
    }

    public boolean botRequiresCodeGrant() {
        return this.data.botRequireCodeGrant();
    }

    public Optional<String> getTermsOfServiceUrl() {
        return this.data.termsOfServiceUrl().toOptional();
    }

    public Optional<String> getPrivacyPolicyUrl() {
        return this.data.privacyPolicyUrl().toOptional();
    }

    public Optional<Snowflake> getOwnerId() {
        return this.data.owner().toOptional().map(data -> Snowflake.of((Id)data.id()));
    }

    public Mono<User> getOwner() {
        return this.getOwnerId().map(this.gateway::getUserById).orElseGet(Mono::empty);
    }

    public Mono<User> getOwner(EntityRetrievalStrategy retrievalStrategy) {
        return this.getOwnerId().map(this.gateway.withRetrievalStrategy(retrievalStrategy)::getUserById).orElseGet(Mono::empty);
    }

    public Optional<ApplicationTeam> getTeam() {
        return this.data.team().map(data -> new ApplicationTeam(this.gateway, (ApplicationTeamData)data));
    }

    public EnumSet<Flag> getFlags() {
        int publicFlags = this.data.flags().toOptional().orElse(0);
        if (publicFlags != 0) {
            return Flag.of(publicFlags);
        }
        return EnumSet.noneOf(Flag.class);
    }

    public String getStoreUrl() {
        return String.format(STORE_URL_SCHEME, this.getId().asString());
    }

    public String getVerifyKey() {
        return this.data.verifyKey();
    }

    public Optional<Snowflake> getBotId() {
        return this.data.bot().toOptional().map(bot -> Snowflake.of((Id)bot.id()));
    }

    public Mono<User> getBot() {
        return this.data.bot().toOptional().map(bot -> this.gateway.getUserById(Snowflake.of((Id)bot.id()))).orElseGet(Mono::empty);
    }

    public Optional<Snowflake> getGuildId() {
        return this.data.guildId().toOptional().map(Snowflake::of);
    }

    public Mono<Guild> getGuild() {
        return this.data.guildId().toOptional().map(Snowflake::of).map(this.gateway::getGuildById).orElseGet(Mono::empty);
    }

    public Optional<Snowflake> getPrimarySkuId() {
        return this.data.primarySkuId().toOptional().map(Snowflake::of);
    }

    public Optional<String> getSlug() {
        return this.data.slug().toOptional();
    }

    public Optional<Integer> getApproximateGuildCount() {
        return this.data.approximateGuildCount().toOptional();
    }

    public List<String> getRedirectUris() {
        return this.data.redirectUris().toOptional().orElse(Collections.emptyList());
    }

    public Optional<String> getInteractionsEndpointUrl() {
        return Possible.flatOpt((Possible)this.data.interactionsEndpointUrl());
    }

    public Optional<String> getRoleConnectionsVerificationUrl() {
        return Possible.flatOpt((Possible)this.data.roleConnectionsVerificationUrl());
    }

    public List<String> getTags() {
        return this.data.tags().toOptional().orElse(Collections.emptyList());
    }

    public Optional<ApplicationInstallParams> getInstallParams() {
        return this.data.installParams().toOptional().map(ApplicationInstallParams::new);
    }

    @Experimental
    public Map<ApplicationIntegrationType, ApplicationIntegrationTypeConfiguration> getIntegrationTypesConfig() {
        return this.data.integrationTypesConfig().toOptional().map(map -> {
            HashMap integrationTypesConfig = new HashMap();
            map.forEach((key, value) -> integrationTypesConfig.put(ApplicationIntegrationType.of(key), new ApplicationIntegrationTypeConfiguration((ApplicationIntegrationTypeConfigurationData)value)));
            return integrationTypesConfig;
        }).orElse(Collections.emptyMap());
    }

    public Optional<String> getCustomInstallUrl() {
        return this.data.customInstallUrl().toOptional();
    }

    public Flux<ApplicationRoleConnectionMetadata> getRoleConnectionMetadata() {
        return this.gateway.rest().getApplicationService().getApplicationRoleConnectionMetadata(this.getId().asLong()).map(ApplicationRoleConnectionMetadata::new);
    }

    public Flux<ApplicationRoleConnectionMetadata> setRoleConnectionMetadata(List<ApplicationRoleConnectionMetadataData> metadata) {
        return this.gateway.rest().getApplicationService().modifyApplicationRoleConnectionMetadata(this.getId().asLong(), metadata).map(ApplicationRoleConnectionMetadata::new);
    }

    public Flux<ApplicationEmoji> getEmojis() {
        return this.gateway.rest().getEmojiService().getApplicationEmojis(this.getId().asLong()).flatMapIterable(ApplicationEmojiDataList::items).map(emojiData -> new ApplicationEmoji(this.gateway, (EmojiData)emojiData, this.getId().asLong()));
    }

    public Mono<ApplicationEmoji> getEmojiById(Snowflake id) {
        return this.gateway.rest().getEmojiService().getApplicationEmoji(this.getId().asLong(), id.asLong()).map(emojiData -> new ApplicationEmoji(this.gateway, (EmojiData)emojiData, id.asLong()));
    }

    public ApplicationEmojiCreateMono createEmoji(String name, Image image) {
        return ApplicationEmojiCreateMono.of(name, image, this);
    }

    public Mono<ApplicationEmoji> createEmoji(ApplicationEmojiCreateSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.gateway.getRestClient().getEmojiService().createApplicationEmoji(this.getId().asLong(), spec.asRequest())).map(data -> new ApplicationEmoji(this.gateway, (EmojiData)data, this.getId().asLong()));
    }

    public ApplicationEditMono edit() {
        return ApplicationEditMono.of(this);
    }

    public Mono<ApplicationInfo> edit(ApplicationEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.gateway.getRestClient().getApplicationService().modifyCurrentApplicationInfo(spec.asRequest())).map(data -> new ApplicationInfo(this.gateway, (ApplicationInfoData)ApplicationInfoData.builder().from(this.data).from(data).build()));
    }

    public boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public int hashCode() {
        return EntityUtil.hashCode(this);
    }

    public String toString() {
        return "ApplicationInfo{data=" + this.data + '}';
    }

    public static enum Flag {
        APPLICATION_AUTO_MODERATION_RULE_CREATE_BADGE(6),
        GATEWAY_PRESENCE(12),
        GATEWAY_PRESENCE_LIMITED(13),
        GATEWAY_GUILD_MEMBERS(14),
        GATEWAY_GUILD_MEMBERS_LIMITED(15),
        VERIFICATION_PENDING_GUILD_LIMIT(16),
        EMBEDDED(17),
        GATEWAY_MESSAGE_CONTENT(18),
        GATEWAY_MESSAGE_CONTENT_LIMITED(19),
        APPLICATION_COMMAND_BADGE(23);

        private final int value;
        private final int flag;

        private Flag(int value) {
            this.value = value;
            this.flag = 1 << value;
        }

        public int getValue() {
            return this.value;
        }

        public int getFlag() {
            return this.flag;
        }

        public static EnumSet<Flag> of(int value) {
            EnumSet<Flag> flagSet = EnumSet.noneOf(Flag.class);
            for (Flag flag : Flag.values()) {
                long flagValue = flag.getFlag();
                if ((flagValue & (long)value) != flagValue) continue;
                flagSet.add(flag);
            }
            return flagSet;
        }
    }
}

