/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.Embed;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.object.entity.Attachment;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.PartialMember;
import discord4j.core.object.entity.PartialSticker;
import discord4j.core.object.entity.User;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AttachmentData;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.PartialMemberData;
import discord4j.discordjson.json.PartialMessageData;
import discord4j.discordjson.json.PartialStickerData;
import discord4j.discordjson.json.UserData;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class PartialMessage
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final PartialMessageData data;

    public PartialMessage(GatewayDiscordClient gateway, PartialMessageData data) {
        this.gateway = gateway;
        this.data = data;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public PartialMessageData getData() {
        return this.data;
    }

    public Optional<Message.Type> getType() {
        return this.data.type().toOptional().map(Message.Type::of);
    }

    public EnumSet<Message.Flag> getFlags() {
        return this.data.flags().toOptional().map(Message.Flag::of).orElse(EnumSet.noneOf(Message.Flag.class));
    }

    public Optional<Snowflake> getGuildId() {
        return this.data.guildId().toOptional().map(Snowflake::of);
    }

    public Optional<User> getAuthor() {
        return !this.data.author().isAbsent() && (this.data.webhookId().isAbsent() || !this.data.interaction().isAbsent()) ? Optional.of(new User(this.gateway, (UserData)this.data.author().get())) : Optional.empty();
    }

    public List<PartialMember> getMemberMentions() {
        if (this.data.guildId().isAbsent()) {
            return Collections.emptyList();
        }
        long guildId = ((Id)this.data.guildId().get()).asLong();
        return this.data.mentions().stream().map(data -> new PartialMember(this.gateway, (UserData)data, (PartialMemberData)data.member().get(), guildId)).collect(Collectors.toList());
    }

    public List<Snowflake> getRoleMentionIds() {
        return this.data.mentionRoles().stream().map(Snowflake::of).collect(Collectors.toList());
    }

    public Optional<String> getContent() {
        return this.data.content().toOptional();
    }

    public List<Embed> getEmbeds() {
        return this.data.embeds().stream().map(data1 -> new Embed(this.gateway, (EmbedData)data1)).collect(Collectors.toList());
    }

    public List<Attachment> getAttachments() {
        return this.data.attachments().stream().map(data -> new Attachment(this.gateway, (AttachmentData)data)).collect(Collectors.toList());
    }

    @Experimental
    public List<PartialSticker> getStickersItems() {
        return this.data.stickerItems().toOptional().map(partialStickers -> partialStickers.stream().map(data -> new PartialSticker(this.gateway, (PartialStickerData)data)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public List<LayoutComponent> getComponents() {
        return this.data.components().toOptional().map(componentList -> componentList.stream().map(MessageComponent::fromData).filter(component -> component instanceof LayoutComponent).map(component -> (LayoutComponent)component).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public Optional<Instant> getTimestamp() {
        return this.data.timestamp().toOptional().map(timestamp -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, Instant::from));
    }

    public Optional<Instant> getEditedTimestamp() {
        return this.data.editedTimestamp().map(timestamp -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, Instant::from));
    }
}

