/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.User;
import discord4j.core.spec.GuildCreateFromTemplateMono;
import discord4j.core.spec.GuildCreateFromTemplateSpec;
import discord4j.core.spec.GuildTemplateEditMono;
import discord4j.core.spec.GuildTemplateEditSpec;
import discord4j.core.spec.legacy.LegacyGuildCreateFromTemplateSpec;
import discord4j.core.spec.legacy.LegacyGuildTemplateEditSpec;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.SerializedSourceGuildData;
import discord4j.discordjson.json.TemplateData;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

public final class GuildTemplate
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final TemplateData data;
    private final long guildId;

    public GuildTemplate(GatewayDiscordClient gateway, TemplateData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
        this.guildId = Snowflake.asLong((Id)data.sourceGuildId());
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public TemplateData getData() {
        return this.data;
    }

    public String getCode() {
        return this.data.code();
    }

    public Snowflake getGuildId() {
        return Snowflake.of((long)this.guildId);
    }

    public String getName() {
        return this.data.name();
    }

    public Optional<String> getDescription() {
        return this.data.description();
    }

    public int getUsageCount() {
        return this.data.usageCount();
    }

    public Snowflake getCreatorId() {
        return Snowflake.of((Id)this.data.creatorId());
    }

    public User getCreator() {
        return new User(this.gateway, this.data.creator());
    }

    public Instant getCreatedAt() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)this.data.createdAt(), Instant::from);
    }

    public Instant getUpdatedAt() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)this.data.updatedAt(), Instant::from);
    }

    public SerializedSourceGuildData getSourceGuild() {
        return this.data.serializedSourceGuild();
    }

    @Deprecated
    public Mono<Guild> createGuild(Consumer<? super LegacyGuildCreateFromTemplateSpec> spec) {
        return Mono.defer(() -> {
            LegacyGuildCreateFromTemplateSpec mutatedSpec = new LegacyGuildCreateFromTemplateSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getTemplateService().createGuild(this.getCode(), mutatedSpec.asRequest());
        }).map(data -> new Guild(this.gateway, (GuildData)data));
    }

    public GuildCreateFromTemplateMono createGuild(String name) {
        return GuildCreateFromTemplateMono.of(name, this);
    }

    public Mono<Guild> createGuild(GuildCreateFromTemplateSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.gateway.getRestClient().getTemplateService().createGuild(this.getCode(), spec.asRequest())).map(data -> new Guild(this.gateway, (GuildData)data));
    }

    public Mono<GuildTemplate> sync() {
        return this.gateway.getRestClient().getTemplateService().syncTemplate(this.guildId, this.getCode()).map(data -> new GuildTemplate(this.gateway, (TemplateData)data));
    }

    @Deprecated
    public Mono<GuildTemplate> edit(Consumer<? super LegacyGuildTemplateEditSpec> spec) {
        return Mono.defer(() -> {
            LegacyGuildTemplateEditSpec mutatedSpec = new LegacyGuildTemplateEditSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getTemplateService().modifyTemplate(this.guildId, this.getCode(), mutatedSpec.asRequest());
        }).map(data -> new GuildTemplate(this.gateway, (TemplateData)data));
    }

    public GuildTemplateEditMono edit() {
        return GuildTemplateEditMono.of(this);
    }

    public Mono<GuildTemplate> edit(GuildTemplateEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.gateway.getRestClient().getTemplateService().modifyTemplate(this.guildId, this.getCode(), spec.asRequest())).map(data -> new GuildTemplate(this.gateway, (TemplateData)data));
    }

    public Mono<GuildTemplate> delete() {
        return this.gateway.getRestClient().getTemplateService().deleteTemplate(this.guildId, this.getCode()).map(data -> new GuildTemplate(this.gateway, (TemplateData)data));
    }
}

