/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.interaction;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.interaction.DeferrableInteractionEvent;
import discord4j.core.object.command.ApplicationCommandInteraction;
import discord4j.core.object.command.Interaction;
import discord4j.core.object.entity.Message;
import discord4j.core.spec.InteractionApplicationCommandCallbackEditMono;
import discord4j.core.spec.InteractionApplicationCommandCallbackSpec;
import discord4j.core.spec.InteractionCallbackSpec;
import discord4j.core.spec.InteractionCallbackSpecDeferEditMono;
import discord4j.core.spec.legacy.LegacyInteractionApplicationCommandCallbackSpec;
import discord4j.discordjson.json.ImmutableInteractionApplicationCommandCallbackData;
import discord4j.discordjson.json.InteractionApplicationCommandCallbackData;
import discord4j.gateway.ShardInfo;
import discord4j.rest.util.InteractionResponseType;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

public class ComponentInteractionEvent
extends DeferrableInteractionEvent {
    public ComponentInteractionEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, Interaction interaction) {
        super(gateway, shardInfo, interaction);
    }

    public String getCustomId() {
        return (String)this.getInteraction().getCommandInteraction().flatMap(ApplicationCommandInteraction::getCustomId).orElseThrow(IllegalStateException::new);
    }

    public Optional<Message> getMessage() {
        return this.getInteraction().getMessage();
    }

    public Snowflake getMessageId() {
        return this.getInteraction().getMessageId().orElseThrow(IllegalStateException::new);
    }

    public InteractionCallbackSpecDeferEditMono deferEdit() {
        return InteractionCallbackSpecDeferEditMono.of(this);
    }

    public Mono<Void> deferEdit(InteractionCallbackSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.createInteractionResponse(InteractionResponseType.DEFERRED_UPDATE_MESSAGE, spec.asRequest()));
    }

    @Deprecated
    public Mono<Void> edit(Consumer<? super LegacyInteractionApplicationCommandCallbackSpec> spec) {
        return Mono.defer(() -> {
            LegacyInteractionApplicationCommandCallbackSpec mutatedSpec = new LegacyInteractionApplicationCommandCallbackSpec();
            this.getClient().getRestClient().getRestResources().getAllowedMentions().ifPresent(mutatedSpec::setAllowedMentions);
            spec.accept(mutatedSpec);
            return this.createInteractionResponse(InteractionResponseType.UPDATE_MESSAGE, mutatedSpec.asRequest());
        });
    }

    public InteractionApplicationCommandCallbackEditMono edit() {
        return InteractionApplicationCommandCallbackEditMono.of(this);
    }

    public InteractionApplicationCommandCallbackEditMono edit(String content) {
        return this.edit().withContent(content);
    }

    public Mono<Void> edit(InteractionApplicationCommandCallbackSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> {
            InteractionApplicationCommandCallbackSpec actualSpec = this.getClient().getRestClient().getRestResources().getAllowedMentions().filter(allowedMentions -> !spec.isAllowedMentionsPresent()).map(spec::withAllowedMentions).orElse(spec);
            return this.createInteractionResponse(InteractionResponseType.UPDATE_MESSAGE, actualSpec.asRequest());
        });
    }

    @Override
    public Mono<Void> acknowledge() {
        return this.createInteractionResponse(InteractionResponseType.DEFERRED_UPDATE_MESSAGE, (InteractionApplicationCommandCallbackData)null);
    }

    @Override
    public Mono<Void> acknowledgeEphemeral() {
        ImmutableInteractionApplicationCommandCallbackData data = InteractionApplicationCommandCallbackData.builder().flags(Integer.valueOf(Message.Flag.EPHEMERAL.getFlag())).build();
        return this.createInteractionResponse(InteractionResponseType.DEFERRED_UPDATE_MESSAGE, (InteractionApplicationCommandCallbackData)data);
    }
}

