/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway;

import discord4j.common.retry.ReconnectOptions;
import discord4j.common.sinks.EmissionStrategy;
import discord4j.gateway.GatewayObserver;
import discord4j.gateway.GatewayReactorResources;
import discord4j.gateway.IdentifyOptions;
import discord4j.gateway.limiter.PayloadTransformer;
import discord4j.gateway.payload.PayloadReader;
import discord4j.gateway.payload.PayloadWriter;
import java.time.Duration;
import java.util.Objects;

public class GatewayOptions {
    private final String token;
    private final GatewayReactorResources reactorResources;
    private final PayloadReader payloadReader;
    private final PayloadWriter payloadWriter;
    private final ReconnectOptions reconnectOptions;
    private final IdentifyOptions identifyOptions;
    private final GatewayObserver initialObserver;
    private final PayloadTransformer identifyLimiter;
    private final int maxMissedHeartbeatAck;
    private final boolean unpooled;
    private final EmissionStrategy emissionStrategy;

    public GatewayOptions(String token, GatewayReactorResources reactorResources, PayloadReader payloadReader, PayloadWriter payloadWriter, ReconnectOptions reconnectOptions, IdentifyOptions identifyOptions, GatewayObserver initialObserver, PayloadTransformer identifyLimiter, int maxMissedHeartbeatAck) {
        this(token, reactorResources, payloadReader, payloadWriter, reconnectOptions, identifyOptions, initialObserver, identifyLimiter, maxMissedHeartbeatAck, false, EmissionStrategy.park((Duration)Duration.ofMillis(10L)));
    }

    public GatewayOptions(String token, GatewayReactorResources reactorResources, PayloadReader payloadReader, PayloadWriter payloadWriter, ReconnectOptions reconnectOptions, IdentifyOptions identifyOptions, GatewayObserver initialObserver, PayloadTransformer identifyLimiter, int maxMissedHeartbeatAck, boolean unpooled, EmissionStrategy emissionStrategy) {
        this.token = Objects.requireNonNull(token, "token");
        this.reactorResources = Objects.requireNonNull(reactorResources, "reactorResources");
        this.payloadReader = Objects.requireNonNull(payloadReader, "payloadReader");
        this.payloadWriter = Objects.requireNonNull(payloadWriter, "payloadWriter");
        this.reconnectOptions = Objects.requireNonNull(reconnectOptions, "reconnectOptions");
        this.identifyOptions = Objects.requireNonNull(identifyOptions, "identifyOptions");
        this.initialObserver = Objects.requireNonNull(initialObserver, "initialObserver");
        this.identifyLimiter = Objects.requireNonNull(identifyLimiter, "identifyLimiter");
        this.maxMissedHeartbeatAck = maxMissedHeartbeatAck;
        this.unpooled = unpooled;
        this.emissionStrategy = Objects.requireNonNull(emissionStrategy, "emissionStrategy");
    }

    public String getToken() {
        return this.token;
    }

    public GatewayReactorResources getReactorResources() {
        return this.reactorResources;
    }

    public PayloadReader getPayloadReader() {
        return this.payloadReader;
    }

    public PayloadWriter getPayloadWriter() {
        return this.payloadWriter;
    }

    public ReconnectOptions getReconnectOptions() {
        return this.reconnectOptions;
    }

    public IdentifyOptions getIdentifyOptions() {
        return this.identifyOptions;
    }

    public GatewayObserver getInitialObserver() {
        return this.initialObserver;
    }

    public PayloadTransformer getIdentifyLimiter() {
        return this.identifyLimiter;
    }

    public int getMaxMissedHeartbeatAck() {
        return this.maxMissedHeartbeatAck;
    }

    public boolean isUnpooled() {
        return this.unpooled;
    }

    public EmissionStrategy getEmissionStrategy() {
        return this.emissionStrategy;
    }
}

