/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.onboarding.Onboarding;
import discord4j.core.spec.OnboardingEditSpecGenerator;
import discord4j.discordjson.json.OnboardingEditPromptData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class OnboardingEditSpec
implements OnboardingEditSpecGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final List<OnboardingEditPromptData> prompts_value;
    private final boolean prompts_absent;
    private final List<Snowflake> defaultChannelIds_value;
    private final boolean defaultChannelIds_absent;
    private final Boolean enabled_value;
    private final boolean enabled_absent;
    private final Onboarding.Mode mode_value;
    private final boolean mode_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private OnboardingEditSpec(@reactor.util.annotation.Nullable String reason, Possible<List<OnboardingEditPromptData>> prompts, Possible<List<Snowflake>> defaultChannelIds, Possible<Boolean> enabled, Possible<Onboarding.Mode> mode) {
        this.reason = reason;
        Possible<List<OnboardingEditPromptData>> prompts$impl = prompts;
        Possible<List<Snowflake>> defaultChannelIds$impl = defaultChannelIds;
        Possible<Boolean> enabled$impl = enabled;
        Possible<Onboarding.Mode> mode$impl = mode;
        this.prompts_value = prompts$impl.toOptional().orElse(null);
        this.prompts_absent = prompts$impl.isAbsent();
        this.defaultChannelIds_value = defaultChannelIds$impl.toOptional().orElse(null);
        this.defaultChannelIds_absent = defaultChannelIds$impl.isAbsent();
        this.enabled_value = enabled$impl.toOptional().orElse(null);
        this.enabled_absent = enabled$impl.isAbsent();
        this.mode_value = mode$impl.toOptional().orElse(null);
        this.mode_absent = mode$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<List<OnboardingEditPromptData>> prompts() {
        return this.prompts_absent ? Possible.absent() : Possible.of(this.prompts_value);
    }

    @Override
    public Possible<List<Snowflake>> defaultChannelIds() {
        return this.defaultChannelIds_absent ? Possible.absent() : Possible.of(this.defaultChannelIds_value);
    }

    @Override
    public Possible<Boolean> enabled() {
        return this.enabled_absent ? Possible.absent() : Possible.of((Object)this.enabled_value);
    }

    @Override
    public Possible<Onboarding.Mode> mode() {
        return this.mode_absent ? Possible.absent() : Possible.of((Object)((Object)this.mode_value));
    }

    public final OnboardingEditSpec withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new OnboardingEditSpec(value, this.prompts(), this.defaultChannelIds(), this.enabled(), this.mode());
    }

    public OnboardingEditSpec withPrompts(Possible<List<OnboardingEditPromptData>> possible) {
        Possible<List<OnboardingEditPromptData>> newValue = Objects.requireNonNull(possible);
        return new OnboardingEditSpec(this.reason, newValue, this.defaultChannelIds(), this.enabled(), this.mode());
    }

    public OnboardingEditSpec withPrompts(Iterable<OnboardingEditPromptData> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new OnboardingEditSpec(this.reason, (Possible<List<OnboardingEditPromptData>>)newValue, this.defaultChannelIds(), this.enabled(), this.mode());
    }

    @SafeVarargs
    public final OnboardingEditSpec withPrompts(OnboardingEditPromptData ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new OnboardingEditSpec(this.reason, (Possible<List<OnboardingEditPromptData>>)newValue, this.defaultChannelIds(), this.enabled(), this.mode());
    }

    public OnboardingEditSpec withDefaultChannelIds(Possible<List<Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return new OnboardingEditSpec(this.reason, this.prompts(), newValue, this.enabled(), this.mode());
    }

    public OnboardingEditSpec withDefaultChannelIds(Iterable<Snowflake> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new OnboardingEditSpec(this.reason, this.prompts(), (Possible<List<Snowflake>>)newValue, this.enabled(), this.mode());
    }

    @SafeVarargs
    public final OnboardingEditSpec withDefaultChannelIds(Snowflake ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new OnboardingEditSpec(this.reason, this.prompts(), (Possible<List<Snowflake>>)newValue, this.enabled(), this.mode());
    }

    public OnboardingEditSpec withEnabled(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new OnboardingEditSpec(this.reason, this.prompts(), this.defaultChannelIds(), newValue, this.mode());
    }

    public OnboardingEditSpec withEnabled(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new OnboardingEditSpec(this.reason, this.prompts(), this.defaultChannelIds(), (Possible<Boolean>)newValue, this.mode());
    }

    public OnboardingEditSpec withMode(Possible<Onboarding.Mode> value) {
        Possible<Onboarding.Mode> newValue = Objects.requireNonNull(value);
        return new OnboardingEditSpec(this.reason, this.prompts(), this.defaultChannelIds(), this.enabled(), newValue);
    }

    public OnboardingEditSpec withMode(Onboarding.Mode value) {
        Possible newValue = Possible.of((Object)((Object)value));
        return new OnboardingEditSpec(this.reason, this.prompts(), this.defaultChannelIds(), this.enabled(), (Possible<Onboarding.Mode>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OnboardingEditSpec && this.equalTo(0, (OnboardingEditSpec)another);
    }

    private boolean equalTo(int synthetic, OnboardingEditSpec another) {
        return Objects.equals(this.reason, another.reason) && Objects.equals(this.prompts_value, another.prompts_value) && Objects.equals(this.defaultChannelIds_value, another.defaultChannelIds_value) && this.enabled().equals(another.enabled()) && this.mode().equals(another.mode());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + Objects.hashCode(this.prompts_value);
        h += (h << 5) + Objects.hashCode(this.defaultChannelIds_value);
        h += (h << 5) + this.enabled().hashCode();
        h += (h << 5) + this.mode().hashCode();
        return h;
    }

    public String toString() {
        return "OnboardingEditSpec{reason=" + this.reason + ", prompts=" + Objects.toString(this.prompts_value) + ", defaultChannelIds=" + Objects.toString(this.defaultChannelIds_value) + ", enabled=" + this.enabled().toString() + ", mode=" + this.mode().toString() + "}";
    }

    public static OnboardingEditSpec copyOf(OnboardingEditSpecGenerator instance) {
        if (instance instanceof OnboardingEditSpec) {
            return (OnboardingEditSpec)instance;
        }
        return OnboardingEditSpec.builder().from(instance).build();
    }

    public boolean isPromptsPresent() {
        return !this.prompts_absent;
    }

    public List<OnboardingEditPromptData> promptsOrElse(List<OnboardingEditPromptData> defaultValue) {
        return !this.prompts_absent ? this.prompts_value : defaultValue;
    }

    public boolean isDefaultChannelIdsPresent() {
        return !this.defaultChannelIds_absent;
    }

    public List<Snowflake> defaultChannelIdsOrElse(List<Snowflake> defaultValue) {
        return !this.defaultChannelIds_absent ? this.defaultChannelIds_value : defaultValue;
    }

    public boolean isEnabledPresent() {
        return !this.enabled_absent;
    }

    public Boolean enabledOrElse(Boolean defaultValue) {
        return !this.enabled_absent ? this.enabled_value : defaultValue;
    }

    public boolean isModePresent() {
        return !this.mode_absent;
    }

    public Onboarding.Mode modeOrElse(Onboarding.Mode defaultValue) {
        return !this.mode_absent ? this.mode_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<OnboardingEditPromptData> prompts_list = null;
        private List<Snowflake> defaultChannelIds_list = null;
        private Possible<Boolean> enabled_possible = Possible.absent();
        private Possible<Onboarding.Mode> mode_possible = Possible.absent();
        @Nullable
        private String reason;

        private Builder() {
        }

        public final Builder from(OnboardingEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.prompts(instance.prompts());
            this.defaultChannelIds(instance.defaultChannelIds());
            this.enabled(instance.enabled());
            this.mode(instance.mode());
            return this;
        }

        public final Builder reason(@reactor.util.annotation.Nullable String reason) {
            this.reason = reason;
            return this;
        }

        public Builder addPrompt(OnboardingEditPromptData element) {
            this.prompts_getOrCreate().add(element);
            return this;
        }

        public Builder addAllPrompts(List<OnboardingEditPromptData> elements) {
            this.prompts_getOrCreate().addAll(elements);
            return this;
        }

        public Builder prompts(Possible<List<OnboardingEditPromptData>> elements) {
            this.prompts_list = null;
            elements.toOptional().ifPresent(e -> this.prompts_getOrCreate().addAll((Collection<OnboardingEditPromptData>)e));
            return this;
        }

        public Builder prompts(List<OnboardingEditPromptData> elements) {
            this.prompts_list = new ArrayList<OnboardingEditPromptData>(elements);
            return this;
        }

        public Builder prompts(Iterable<OnboardingEditPromptData> elements) {
            this.prompts_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public Builder addDefaultChannelId(Snowflake element) {
            this.defaultChannelIds_getOrCreate().add(element);
            return this;
        }

        public Builder addAllDefaultChannelIds(List<Snowflake> elements) {
            this.defaultChannelIds_getOrCreate().addAll(elements);
            return this;
        }

        public Builder defaultChannelIds(Possible<List<Snowflake>> elements) {
            this.defaultChannelIds_list = null;
            elements.toOptional().ifPresent(e -> this.defaultChannelIds_getOrCreate().addAll((Collection<Snowflake>)e));
            return this;
        }

        public Builder defaultChannelIds(List<Snowflake> elements) {
            this.defaultChannelIds_list = new ArrayList<Snowflake>(elements);
            return this;
        }

        public Builder defaultChannelIds(Iterable<Snowflake> elements) {
            this.defaultChannelIds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public Builder enabled(Possible<Boolean> value) {
            this.enabled_possible = value;
            return this;
        }

        public Builder enabled(Boolean value) {
            this.enabled_possible = Possible.of((Object)value);
            return this;
        }

        public Builder mode(Possible<Onboarding.Mode> value) {
            this.mode_possible = value;
            return this;
        }

        public Builder mode(Onboarding.Mode value) {
            this.mode_possible = Possible.of((Object)((Object)value));
            return this;
        }

        public OnboardingEditSpec build() {
            return new OnboardingEditSpec(this.reason, this.prompts_build(), this.defaultChannelIds_build(), this.enabled_build(), this.mode_build());
        }

        private Possible<List<OnboardingEditPromptData>> prompts_build() {
            return this.prompts_list == null ? Possible.absent() : Possible.of(this.prompts_list);
        }

        private List<OnboardingEditPromptData> prompts_getOrCreate() {
            if (this.prompts_list == null) {
                this.prompts_list = new ArrayList<OnboardingEditPromptData>();
            }
            return this.prompts_list;
        }

        private Possible<List<Snowflake>> defaultChannelIds_build() {
            return this.defaultChannelIds_list == null ? Possible.absent() : Possible.of(this.defaultChannelIds_list);
        }

        private List<Snowflake> defaultChannelIds_getOrCreate() {
            if (this.defaultChannelIds_list == null) {
                this.defaultChannelIds_list = new ArrayList<Snowflake>();
            }
            return this.defaultChannelIds_list;
        }

        private Possible<Boolean> enabled_build() {
            return this.enabled_possible;
        }

        private Possible<Onboarding.Mode> mode_build() {
            return this.mode_possible;
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build OnboardingEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

