/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.onboarding.Onboarding;
import discord4j.core.spec.OnboardingEditMonoGenerator;
import discord4j.discordjson.json.OnboardingEditPromptData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class OnboardingEditMono
extends OnboardingEditMonoGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final List<OnboardingEditPromptData> prompts_value;
    private final boolean prompts_absent;
    private final List<Snowflake> defaultChannelIds_value;
    private final boolean defaultChannelIds_absent;
    private final Boolean enabled_value;
    private final boolean enabled_absent;
    private final Onboarding.Mode mode_value;
    private final boolean mode_absent;
    private final Guild guild;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private OnboardingEditMono(Guild guild) {
        this.guild = Objects.requireNonNull(guild, "guild");
        this.reason = null;
        Possible prompts$impl = Possible.absent();
        Possible defaultChannelIds$impl = Possible.absent();
        Possible enabled$impl = Possible.absent();
        Possible mode$impl = Possible.absent();
        this.prompts_value = prompts$impl.toOptional().orElse(null);
        this.prompts_absent = prompts$impl.isAbsent();
        this.defaultChannelIds_value = defaultChannelIds$impl.toOptional().orElse(null);
        this.defaultChannelIds_absent = defaultChannelIds$impl.isAbsent();
        this.enabled_value = enabled$impl.toOptional().orElse(null);
        this.enabled_absent = enabled$impl.isAbsent();
        this.mode_value = mode$impl.toOptional().orElse(null);
        this.mode_absent = mode$impl.isAbsent();
        this.initShim = null;
    }

    private OnboardingEditMono(@reactor.util.annotation.Nullable String reason, Possible<List<OnboardingEditPromptData>> prompts, Possible<List<Snowflake>> defaultChannelIds, Possible<Boolean> enabled, Possible<Onboarding.Mode> mode, Guild guild) {
        this.reason = reason;
        Possible<List<OnboardingEditPromptData>> prompts$impl = prompts;
        Possible<List<Snowflake>> defaultChannelIds$impl = defaultChannelIds;
        Possible<Boolean> enabled$impl = enabled;
        Possible<Onboarding.Mode> mode$impl = mode;
        this.guild = guild;
        this.prompts_value = prompts$impl.toOptional().orElse(null);
        this.prompts_absent = prompts$impl.isAbsent();
        this.defaultChannelIds_value = defaultChannelIds$impl.toOptional().orElse(null);
        this.defaultChannelIds_absent = defaultChannelIds$impl.isAbsent();
        this.enabled_value = enabled$impl.toOptional().orElse(null);
        this.enabled_absent = enabled$impl.isAbsent();
        this.mode_value = mode$impl.toOptional().orElse(null);
        this.mode_absent = mode$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<List<OnboardingEditPromptData>> prompts() {
        return this.prompts_absent ? Possible.absent() : Possible.of(this.prompts_value);
    }

    @Override
    public Possible<List<Snowflake>> defaultChannelIds() {
        return this.defaultChannelIds_absent ? Possible.absent() : Possible.of(this.defaultChannelIds_value);
    }

    @Override
    public Possible<Boolean> enabled() {
        return this.enabled_absent ? Possible.absent() : Possible.of((Object)this.enabled_value);
    }

    @Override
    public Possible<Onboarding.Mode> mode() {
        return this.mode_absent ? Possible.absent() : Possible.of((Object)((Object)this.mode_value));
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final OnboardingEditMono withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new OnboardingEditMono(value, this.prompts(), this.defaultChannelIds(), this.enabled(), this.mode(), this.guild);
    }

    public OnboardingEditMono withPrompts(Possible<List<OnboardingEditPromptData>> possible) {
        Possible<List<OnboardingEditPromptData>> newValue = Objects.requireNonNull(possible);
        return new OnboardingEditMono(this.reason, newValue, this.defaultChannelIds(), this.enabled(), this.mode(), this.guild);
    }

    public OnboardingEditMono withPrompts(Iterable<OnboardingEditPromptData> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new OnboardingEditMono(this.reason, (Possible<List<OnboardingEditPromptData>>)newValue, this.defaultChannelIds(), this.enabled(), this.mode(), this.guild);
    }

    @SafeVarargs
    public final OnboardingEditMono withPrompts(OnboardingEditPromptData ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new OnboardingEditMono(this.reason, (Possible<List<OnboardingEditPromptData>>)newValue, this.defaultChannelIds(), this.enabled(), this.mode(), this.guild);
    }

    public OnboardingEditMono withDefaultChannelIds(Possible<List<Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return new OnboardingEditMono(this.reason, this.prompts(), newValue, this.enabled(), this.mode(), this.guild);
    }

    public OnboardingEditMono withDefaultChannelIds(Iterable<Snowflake> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new OnboardingEditMono(this.reason, this.prompts(), (Possible<List<Snowflake>>)newValue, this.enabled(), this.mode(), this.guild);
    }

    @SafeVarargs
    public final OnboardingEditMono withDefaultChannelIds(Snowflake ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new OnboardingEditMono(this.reason, this.prompts(), (Possible<List<Snowflake>>)newValue, this.enabled(), this.mode(), this.guild);
    }

    public OnboardingEditMono withEnabled(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new OnboardingEditMono(this.reason, this.prompts(), this.defaultChannelIds(), newValue, this.mode(), this.guild);
    }

    public OnboardingEditMono withEnabled(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new OnboardingEditMono(this.reason, this.prompts(), this.defaultChannelIds(), (Possible<Boolean>)newValue, this.mode(), this.guild);
    }

    public OnboardingEditMono withMode(Possible<Onboarding.Mode> value) {
        Possible<Onboarding.Mode> newValue = Objects.requireNonNull(value);
        return new OnboardingEditMono(this.reason, this.prompts(), this.defaultChannelIds(), this.enabled(), newValue, this.guild);
    }

    public OnboardingEditMono withMode(Onboarding.Mode value) {
        Possible newValue = Possible.of((Object)((Object)value));
        return new OnboardingEditMono(this.reason, this.prompts(), this.defaultChannelIds(), this.enabled(), (Possible<Onboarding.Mode>)newValue, this.guild);
    }

    public final OnboardingEditMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new OnboardingEditMono(this.reason, this.prompts(), this.defaultChannelIds(), this.enabled(), this.mode(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OnboardingEditMono && this.equalTo(0, (OnboardingEditMono)another);
    }

    private boolean equalTo(int synthetic, OnboardingEditMono another) {
        return Objects.equals(this.reason, another.reason) && Objects.equals(this.prompts_value, another.prompts_value) && Objects.equals(this.defaultChannelIds_value, another.defaultChannelIds_value) && this.enabled().equals(another.enabled()) && this.mode().equals(another.mode()) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + Objects.hashCode(this.prompts_value);
        h += (h << 5) + Objects.hashCode(this.defaultChannelIds_value);
        h += (h << 5) + this.enabled().hashCode();
        h += (h << 5) + this.mode().hashCode();
        h += (h << 5) + this.guild.hashCode();
        return h;
    }

    public static OnboardingEditMono of(Guild guild) {
        return new OnboardingEditMono(guild);
    }

    static OnboardingEditMono copyOf(OnboardingEditMonoGenerator instance) {
        if (instance instanceof OnboardingEditMono) {
            return (OnboardingEditMono)instance;
        }
        return OnboardingEditMono.of(instance.guild()).withReason(instance.reason()).withPrompts((Possible<List<OnboardingEditPromptData>>)instance.prompts()).withDefaultChannelIds((Possible<List<Snowflake>>)instance.defaultChannelIds()).withEnabled((Possible<Boolean>)instance.enabled()).withMode((Possible<Onboarding.Mode>)instance.mode());
    }

    public boolean isPromptsPresent() {
        return !this.prompts_absent;
    }

    public List<OnboardingEditPromptData> promptsOrElse(List<OnboardingEditPromptData> defaultValue) {
        return !this.prompts_absent ? this.prompts_value : defaultValue;
    }

    public boolean isDefaultChannelIdsPresent() {
        return !this.defaultChannelIds_absent;
    }

    public List<Snowflake> defaultChannelIdsOrElse(List<Snowflake> defaultValue) {
        return !this.defaultChannelIds_absent ? this.defaultChannelIds_value : defaultValue;
    }

    public boolean isEnabledPresent() {
        return !this.enabled_absent;
    }

    public Boolean enabledOrElse(Boolean defaultValue) {
        return !this.enabled_absent ? this.enabled_value : defaultValue;
    }

    public boolean isModePresent() {
        return !this.mode_absent;
    }

    public Onboarding.Mode modeOrElse(Onboarding.Mode defaultValue) {
        return !this.mode_absent ? this.mode_value : defaultValue;
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build OnboardingEditMono, attribute initializers form cycle " + attributes;
        }
    }
}

