/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.BulkBanRequestMonoGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class BulkBanRequestMono
extends BulkBanRequestMonoGenerator {
    @reactor.util.annotation.Nullable
    private final String reason;
    private final List<Snowflake> userIds;
    private final Integer deleteMessageSeconds_value;
    private final boolean deleteMessageSeconds_absent;
    private final Guild guild;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private BulkBanRequestMono(Guild guild) {
        this.guild = Objects.requireNonNull(guild, "guild");
        this.reason = null;
        this.userIds = Collections.emptyList();
        Possible deleteMessageSeconds$impl = Possible.absent();
        this.deleteMessageSeconds_value = deleteMessageSeconds$impl.toOptional().orElse(null);
        this.deleteMessageSeconds_absent = deleteMessageSeconds$impl.isAbsent();
        this.initShim = null;
    }

    private BulkBanRequestMono(@reactor.util.annotation.Nullable String reason, List<Snowflake> userIds, Possible<Integer> deleteMessageSeconds, Guild guild) {
        this.reason = reason;
        this.userIds = userIds;
        Possible<Integer> deleteMessageSeconds$impl = deleteMessageSeconds;
        this.guild = guild;
        this.deleteMessageSeconds_value = deleteMessageSeconds$impl.toOptional().orElse(null);
        this.deleteMessageSeconds_absent = deleteMessageSeconds$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @reactor.util.annotation.Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public List<Snowflake> userIds() {
        return this.userIds;
    }

    @Override
    public Possible<Integer> deleteMessageSeconds() {
        return this.deleteMessageSeconds_absent ? Possible.absent() : Possible.of((Object)this.deleteMessageSeconds_value);
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final BulkBanRequestMono withReason(@reactor.util.annotation.Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new BulkBanRequestMono(value, this.userIds, this.deleteMessageSeconds(), this.guild);
    }

    public final BulkBanRequestMono withUserIds(Snowflake ... elements) {
        List<Snowflake> newValue = BulkBanRequestMono.createUnmodifiableList(false, BulkBanRequestMono.createSafeList(Arrays.asList(elements), true, false));
        return new BulkBanRequestMono(this.reason, newValue, this.deleteMessageSeconds(), this.guild);
    }

    public final BulkBanRequestMono withUserIds(Iterable<? extends Snowflake> elements) {
        if (this.userIds == elements) {
            return this;
        }
        List<Snowflake> newValue = BulkBanRequestMono.createUnmodifiableList(false, BulkBanRequestMono.createSafeList(elements, true, false));
        return new BulkBanRequestMono(this.reason, newValue, this.deleteMessageSeconds(), this.guild);
    }

    public BulkBanRequestMono withDeleteMessageSeconds(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new BulkBanRequestMono(this.reason, this.userIds, newValue, this.guild);
    }

    public BulkBanRequestMono withDeleteMessageSeconds(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new BulkBanRequestMono(this.reason, this.userIds, (Possible<Integer>)newValue, this.guild);
    }

    public final BulkBanRequestMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new BulkBanRequestMono(this.reason, this.userIds, this.deleteMessageSeconds(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BulkBanRequestMono && this.equalTo(0, (BulkBanRequestMono)another);
    }

    private boolean equalTo(int synthetic, BulkBanRequestMono another) {
        return Objects.equals(this.reason, another.reason) && this.userIds.equals(another.userIds) && this.deleteMessageSeconds().equals(another.deleteMessageSeconds()) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.userIds.hashCode();
        h += (h << 5) + this.deleteMessageSeconds().hashCode();
        h += (h << 5) + this.guild.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "BulkBanRequestMono{reason=" + this.reason + ", userIds=" + this.userIds + ", deleteMessageSeconds=" + this.deleteMessageSeconds().toString() + ", guild=" + this.guild + "}";
    }

    public static BulkBanRequestMono of(Guild guild) {
        return new BulkBanRequestMono(guild);
    }

    static BulkBanRequestMono copyOf(BulkBanRequestMonoGenerator instance) {
        if (instance instanceof BulkBanRequestMono) {
            return (BulkBanRequestMono)instance;
        }
        return BulkBanRequestMono.of(instance.guild()).withReason(instance.reason()).withUserIds(instance.userIds()).withDeleteMessageSeconds((Possible<Integer>)instance.deleteMessageSeconds());
    }

    public boolean isDeleteMessageSecondsPresent() {
        return !this.deleteMessageSeconds_absent;
    }

    public Integer deleteMessageSecondsOrElse(Integer defaultValue) {
        return !this.deleteMessageSeconds_absent ? this.deleteMessageSeconds_value : defaultValue;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build BulkBanRequestMono, attribute initializers form cycle " + attributes;
        }
    }
}

