/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.spec.ApplicationEmojiCreateSpecGenerator;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ApplicationEmojiCreateSpec
implements ApplicationEmojiCreateSpecGenerator {
    private final String name;
    private final Image image;

    private ApplicationEmojiCreateSpec(String name, Image image) {
        this.name = Objects.requireNonNull(name, "name");
        this.image = Objects.requireNonNull(image, "image");
    }

    private ApplicationEmojiCreateSpec(ApplicationEmojiCreateSpec original, String name, Image image) {
        this.name = name;
        this.image = image;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Image image() {
        return this.image;
    }

    public final ApplicationEmojiCreateSpec withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ApplicationEmojiCreateSpec(this, newValue, this.image);
    }

    public final ApplicationEmojiCreateSpec withImage(Image value) {
        if (this.image == value) {
            return this;
        }
        Image newValue = Objects.requireNonNull(value, "image");
        return new ApplicationEmojiCreateSpec(this, this.name, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ApplicationEmojiCreateSpec && this.equalTo(0, (ApplicationEmojiCreateSpec)another);
    }

    private boolean equalTo(int synthetic, ApplicationEmojiCreateSpec another) {
        return this.name.equals(another.name) && this.image.equals((Object)another.image);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.image.hashCode();
        return h;
    }

    public String toString() {
        return "ApplicationEmojiCreateSpec{name=" + this.name + ", image=" + this.image + "}";
    }

    public static ApplicationEmojiCreateSpec of(String name, Image image) {
        return new ApplicationEmojiCreateSpec(name, image);
    }

    static ApplicationEmojiCreateSpec copyOf(ApplicationEmojiCreateSpecGenerator instance) {
        if (instance instanceof ApplicationEmojiCreateSpec) {
            return (ApplicationEmojiCreateSpec)instance;
        }
        return ApplicationEmojiCreateSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_IMAGE = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        @Nullable
        private Image image;

        private Builder() {
        }

        public final Builder from(ApplicationEmojiCreateSpec instance) {
            return this.from((ApplicationEmojiCreateSpecGenerator)instance);
        }

        final Builder from(ApplicationEmojiCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.image(instance.image());
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder image(Image image) {
            this.image = Objects.requireNonNull(image, "image");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ApplicationEmojiCreateSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ApplicationEmojiCreateSpec(null, this.name, this.image);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("image");
            }
            return "Cannot build ApplicationEmojiCreateSpec, some of required attributes are not set " + attributes;
        }
    }
}

