/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.User;
import discord4j.core.util.ImageUtil;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.IntegrationApplicationData;
import discord4j.discordjson.json.UserData;
import discord4j.rest.util.Image;
import java.util.Objects;
import java.util.Optional;

public class IntegrationApplication
implements Entity {
    private static final String ICON_IMAGE_PATH = "app-icons/%s/%s";
    private final GatewayDiscordClient gateway;
    private final IntegrationApplicationData data;

    public IntegrationApplication(GatewayDiscordClient gateway, IntegrationApplicationData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    public IntegrationApplicationData getData() {
        return this.data;
    }

    public String getName() {
        return this.data.name();
    }

    public Optional<String> getIconUrl(Image.Format format) {
        return this.data.icon().map(icon -> ImageUtil.getUrl(String.format(ICON_IMAGE_PATH, this.getId().asString(), icon), format));
    }

    public String getDescription() {
        return this.data.description();
    }

    @Deprecated
    public String getSummary() {
        return this.data.summary();
    }

    public Optional<User> getBot() {
        return this.data.bot().toOptional().map(data -> new User(this.gateway, (UserData)data));
    }
}

