/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.entity.PartialMember;
import discord4j.core.object.entity.User;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.GuildScheduledEventUserData;
import discord4j.discordjson.json.PartialMemberData;
import java.util.Objects;
import java.util.Optional;

public class ScheduledEventUser
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final GuildScheduledEventUserData data;
    private final Snowflake guildId;

    public ScheduledEventUser(GatewayDiscordClient gateway, GuildScheduledEventUserData data, Snowflake guildId) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
        this.guildId = Objects.requireNonNull(guildId);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public Snowflake getEventId() {
        return Snowflake.of((Id)this.data.guildScheduledEventId());
    }

    public User getUser() {
        return new User(this.gateway, this.data.user());
    }

    public Optional<PartialMember> getMember() {
        return this.data.member().toOptional().map(memberData -> new PartialMember(this.gateway, this.data.user(), (PartialMemberData)memberData, this.guildId.asLong()));
    }

    public String toString() {
        return "ScheduledEventUser{data=" + this.data + '}';
    }
}

