/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.entity.Webhook;
import discord4j.core.object.entity.channel.NewsChannel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.FollowedChannelData;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class FollowedChannel
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final FollowedChannelData data;

    public FollowedChannel(GatewayDiscordClient gateway, FollowedChannelData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public final GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public FollowedChannelData getData() {
        return this.data;
    }

    public Snowflake getNewsChannelId() {
        return Snowflake.of((Id)this.data.channelId());
    }

    public Mono<NewsChannel> getNewsChannel() {
        return this.gateway.getChannelById(Snowflake.of((Id)this.data.channelId())).cast(NewsChannel.class);
    }

    public Mono<NewsChannel> getNewsChannel(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById(Snowflake.of((Id)this.data.channelId())).cast(NewsChannel.class);
    }

    public Snowflake getWebhookId() {
        return Snowflake.of((Id)this.data.webhookId());
    }

    public Mono<Webhook> getWebhook() {
        return this.gateway.getWebhookById(Snowflake.of((Id)this.data.webhookId()));
    }
}

