/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.lifecycle;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.lifecycle.GatewayLifecycleEvent;
import discord4j.core.object.entity.User;
import discord4j.discordjson.json.gateway.Ready;
import discord4j.gateway.ShardInfo;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import reactor.util.annotation.Nullable;

public class ReadyEvent
extends GatewayLifecycleEvent {
    private final Ready data;
    private final User self;
    private final Set<Guild> guilds;

    public ReadyEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, Ready data, User self, Set<Guild> guilds) {
        super(gateway, shardInfo);
        this.data = data;
        this.self = self;
        this.guilds = guilds;
    }

    public Ready getData() {
        return this.data;
    }

    public int getGatewayVersion() {
        return this.data.v();
    }

    public User getSelf() {
        return this.self;
    }

    public Set<Guild> getGuilds() {
        return this.guilds;
    }

    public String getSessionId() {
        return this.data.sessionId();
    }

    public List<String> getTrace() {
        return this.data.trace();
    }

    public String toString() {
        return "ReadyEvent{data=" + this.data + ", self=" + this.self + ", guilds=" + this.guilds + '}';
    }

    public static class Guild {
        private final long id;
        private final boolean available;

        public Guild(long id, boolean available) {
            this.id = id;
            this.available = available;
        }

        public Snowflake getId() {
            return Snowflake.of((long)this.id);
        }

        public boolean isAvailable() {
            return this.available;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Guild guild = (Guild)o;
            return this.id == guild.id && this.available == guild.available;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.available);
        }

        public String toString() {
            return "Guild{id=" + this.id + ", available=" + this.available + '}';
        }
    }
}

