/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event;

import discord4j.common.LogUtil;
import discord4j.core.event.DefaultEventDispatcher;
import discord4j.core.event.ReactiveEventAdapter;
import discord4j.core.event.ReplayingEventDispatcher;
import discord4j.core.event.SinksEventDispatcher;
import discord4j.core.event.domain.Event;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxProcessor;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Scheduler;
import reactor.scheduler.forkjoin.ForkJoinPoolScheduler;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

public interface EventDispatcher {
    public static final Logger log = Loggers.getLogger(EventDispatcher.class);
    public static final Supplier<Scheduler> DEFAULT_EVENT_SCHEDULER = () -> ForkJoinPoolScheduler.create((String)"d4j-events");

    public <E extends Event> Flux<E> on(Class<E> var1);

    default public <E extends Event, T> Flux<T> on(Class<E> eventClass, Function<E, Publisher<T>> mapper) {
        return this.on(eventClass).flatMap(event -> Flux.defer(() -> (Publisher)mapper.apply(event)).contextWrite(ctx -> ctx.put((Object)"discord4j.shard", (Object)event.getShardInfo().getIndex())).onErrorResume(t -> {
            log.warn(LogUtil.format((ContextView)Context.of((Object)"discord4j.shard", (Object)event.getShardInfo().getIndex()), (String)"Error while handling {}"), new Object[]{eventClass.getSimpleName(), t});
            return Mono.empty();
        }));
    }

    default public Flux<Event> on(ReactiveEventAdapter adapter) {
        return this.on(Event.class).flatMap(event -> Flux.defer(() -> adapter.hookOnEvent((Event)event)).contextWrite(ctx -> ctx.put((Object)"discord4j.shard", (Object)event.getShardInfo().getIndex())).onErrorResume(t -> {
            log.warn(LogUtil.format((ContextView)Context.of((Object)"discord4j.shard", (Object)event.getShardInfo().getIndex()), (String)"Error while handling {}"), new Object[]{event.getClass().getSimpleName(), t});
            return Mono.empty();
        }).then(Mono.just((Object)event)));
    }

    public void publish(Event var1);

    public void shutdown();

    public static Builder builder() {
        return new DefaultEventDispatcher.Builder();
    }

    public static EventDispatcher buffering() {
        return EventDispatcher.builder().build();
    }

    public static EventDispatcher withEarliestEvents(int bufferSize) {
        return EventDispatcher.builder().eventSink(spec -> spec.multicast().onBackpressureBuffer(bufferSize, false)).build();
    }

    public static EventDispatcher withLatestEvents(int bufferSize) {
        return EventDispatcher.builder().eventProcessor((FluxProcessor<Event, Event>)EmitterProcessor.create((int)bufferSize, (boolean)false)).overflowStrategy(FluxSink.OverflowStrategy.LATEST).build();
    }

    public static EventDispatcher replaying() {
        return ReplayingEventDispatcher.create();
    }

    public static EventDispatcher replayingWithTimeout(Duration maxAge) {
        return EventDispatcher.builder().eventSink(spec -> spec.replay().limit(maxAge)).build();
    }

    public static EventDispatcher replayingWithSize(int historySize) {
        return EventDispatcher.builder().eventSink(spec -> spec.replay().limit(historySize)).build();
    }

    public static interface Builder {
        public SinksEventDispatcher.Builder eventSink(Function<Sinks.ManySpec, Sinks.Many<Event>> var1);

        @Deprecated
        public DefaultEventDispatcher.Builder eventProcessor(FluxProcessor<Event, Event> var1);

        @Deprecated
        public DefaultEventDispatcher.Builder overflowStrategy(FluxSink.OverflowStrategy var1);

        public DefaultEventDispatcher.Builder eventScheduler(Scheduler var1);

        public EventDispatcher build();
    }
}

