/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core;

import discord4j.common.GitProperties;
import discord4j.core.CoreResources;
import discord4j.core.DiscordClient;
import discord4j.rest.RestClientBuilder;
import discord4j.rest.request.DefaultRouter;
import discord4j.rest.request.Router;
import discord4j.rest.request.RouterOptions;
import java.util.Properties;
import java.util.function.Function;
import reactor.util.Logger;
import reactor.util.Loggers;

public final class DiscordClientBuilder<C, O extends RouterOptions>
extends RestClientBuilder<C, O> {
    private static final Logger log = Loggers.getLogger(DiscordClientBuilder.class);

    public static DiscordClientBuilder<DiscordClient, RouterOptions> create(String token) {
        Function<RestClientBuilder.Config, DiscordClient> clientFactory = config -> {
            CoreResources coreResources = new CoreResources(config.getToken(), config.getReactorResources(), config.getJacksonResources(), config.getRouter(), config.getAllowedMentions().orElse(null));
            Properties properties = GitProperties.getProperties();
            String url = properties.getProperty("application.url", "https://discord4j.com");
            String name = properties.getProperty("application.name", "Discord4J");
            String version = properties.getProperty("git.build.version", "3.2");
            String gitDescribe = properties.getProperty("git.commit.id.describe", version);
            log.info("{} {} ({})", new Object[]{name, gitDescribe, url});
            return new DiscordClient(coreResources);
        };
        return new DiscordClientBuilder<DiscordClient, RouterOptions>(token, clientFactory, Function.identity());
    }

    DiscordClientBuilder(String token, Function<RestClientBuilder.Config, C> allocator, Function<RouterOptions, O> optionsModifier) {
        super(token, allocator, optionsModifier);
    }

    DiscordClientBuilder(DiscordClientBuilder<?, ?> source, Function<RestClientBuilder.Config, C> allocator, Function<RouterOptions, O> optionsModifier) {
        super(source, allocator, optionsModifier);
    }

    public C build() {
        return this.build(DefaultRouter::new);
    }

    public C build(Function<O, Router> routerFactory) {
        return (C)super.build(routerFactory);
    }
}

