/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.gateway.ChannelDelete;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableChannelDelete
implements ChannelDelete {
    private final ChannelData channel;

    private ImmutableChannelDelete(ChannelData channel) {
        this.channel = Objects.requireNonNull(channel, "channel");
    }

    private ImmutableChannelDelete(ImmutableChannelDelete original, ChannelData channel) {
        this.channel = channel;
    }

    @Override
    @JsonProperty(value="channel")
    @JsonUnwrapped
    public ChannelData channel() {
        return this.channel;
    }

    public final ImmutableChannelDelete withChannel(ChannelData value) {
        if (this.channel == value) {
            return this;
        }
        ChannelData newValue = Objects.requireNonNull(value, "channel");
        return new ImmutableChannelDelete(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChannelDelete && this.equalTo(0, (ImmutableChannelDelete)another);
    }

    private boolean equalTo(int synthetic, ImmutableChannelDelete another) {
        return this.channel.equals(another.channel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channel.hashCode();
        return h;
    }

    public String toString() {
        return "ChannelDelete{channel=" + this.channel + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableChannelDelete fromJson(Json json) {
        Builder builder = ImmutableChannelDelete.builder();
        if (json.channel != null) {
            builder.channel(json.channel);
        }
        return builder.build();
    }

    public static ImmutableChannelDelete of(ChannelData channel) {
        return new ImmutableChannelDelete(channel);
    }

    public static ImmutableChannelDelete copyOf(ChannelDelete instance) {
        if (instance instanceof ImmutableChannelDelete) {
            return (ImmutableChannelDelete)instance;
        }
        return ImmutableChannelDelete.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CHANNEL = 1L;
        private long initBits = 1L;
        @Nullable
        private ChannelData channel;

        private Builder() {
        }

        public final Builder from(ChannelDelete instance) {
            Objects.requireNonNull(instance, "instance");
            this.channel(instance.channel());
            return this;
        }

        @JsonProperty(value="channel")
        @JsonUnwrapped
        public final Builder channel(ChannelData channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableChannelDelete build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChannelDelete(null, this.channel);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("channel");
            }
            return "Cannot build ChannelDelete, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ChannelDelete {
        @Nullable
        ChannelData channel;

        Json() {
        }

        @JsonProperty(value="channel")
        @JsonUnwrapped
        public void setChannel(ChannelData channel) {
            this.channel = channel;
        }

        @Override
        public ChannelData channel() {
            throw new UnsupportedOperationException();
        }
    }
}

