/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.MessageReferenceData;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableMessageReferenceData
implements MessageReferenceData {
    private final int type;
    private final long messageId_value;
    private final boolean messageId_absent;
    private final long channelId_value;
    private final boolean channelId_absent;
    private final long guildId_value;
    private final boolean guildId_absent;
    private final Boolean failIfNotExists_value;
    private final boolean failIfNotExists_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMessageReferenceData(int type, Possible<Id> messageId, Possible<Id> channelId, Possible<Id> guildId, Possible<Boolean> failIfNotExists) {
        this.initShim.type(type);
        Possible<Id> messageId$impl = messageId;
        Possible<Id> channelId$impl = channelId;
        Possible<Id> guildId$impl = guildId;
        Possible<Boolean> failIfNotExists$impl = failIfNotExists;
        this.messageId_value = messageId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.messageId_absent = messageId$impl.isAbsent();
        this.channelId_value = channelId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.channelId_absent = channelId$impl.isAbsent();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.failIfNotExists_value = failIfNotExists$impl.toOptional().orElse(null);
        this.failIfNotExists_absent = failIfNotExists$impl.isAbsent();
        this.type = this.initShim.type();
        this.initShim = null;
    }

    private ImmutableMessageReferenceData(Builder builder) {
        Possible messageId$impl = builder.messageId_build();
        Possible channelId$impl = builder.channelId_build();
        Possible guildId$impl = builder.guildId_build();
        Possible failIfNotExists$impl = builder.failIfNotExists_build();
        if (builder.typeIsSet()) {
            this.initShim.type(builder.type);
        }
        this.messageId_value = messageId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.messageId_absent = messageId$impl.isAbsent();
        this.channelId_value = channelId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.channelId_absent = channelId$impl.isAbsent();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.failIfNotExists_value = failIfNotExists$impl.toOptional().orElse(null);
        this.failIfNotExists_absent = failIfNotExists$impl.isAbsent();
        this.type = this.initShim.type();
        this.initShim = null;
    }

    private ImmutableMessageReferenceData(ImmutableMessageReferenceData original, int type, Possible<Id> messageId, Possible<Id> channelId, Possible<Id> guildId, Possible<Boolean> failIfNotExists) {
        this.initShim.type(type);
        Possible<Id> messageId$impl = messageId;
        Possible<Id> channelId$impl = channelId;
        Possible<Id> guildId$impl = guildId;
        Possible<Boolean> failIfNotExists$impl = failIfNotExists;
        this.messageId_value = messageId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.messageId_absent = messageId$impl.isAbsent();
        this.channelId_value = channelId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.channelId_absent = channelId$impl.isAbsent();
        this.guildId_value = guildId$impl.toOptional().map(Id::asLong).orElse(0L);
        this.guildId_absent = guildId$impl.isAbsent();
        this.failIfNotExists_value = failIfNotExists$impl.toOptional().orElse(null);
        this.failIfNotExists_absent = failIfNotExists$impl.isAbsent();
        this.type = this.initShim.type();
        this.initShim = null;
    }

    private int typeInitialize() {
        return MessageReferenceData.super.type();
    }

    @Override
    @JsonProperty(value="type")
    public int type() {
        InitShim shim = this.initShim;
        return shim != null ? shim.type() : this.type;
    }

    @Override
    @JsonProperty(value="message_id")
    public Possible<Id> messageId() {
        return this.messageId_absent ? Possible.absent() : Possible.of((Object)Id.of((long)this.messageId_value));
    }

    @Override
    @JsonProperty(value="channel_id")
    public Possible<Id> channelId() {
        return this.channelId_absent ? Possible.absent() : Possible.of((Object)Id.of((long)this.channelId_value));
    }

    @Override
    @JsonProperty(value="guild_id")
    public Possible<Id> guildId() {
        return this.guildId_absent ? Possible.absent() : Possible.of((Object)Id.of((long)this.guildId_value));
    }

    @Override
    @JsonProperty(value="fail_if_not_exists")
    public Possible<Boolean> failIfNotExists() {
        return this.failIfNotExists_absent ? Possible.absent() : Possible.of((Object)this.failIfNotExists_value);
    }

    public final ImmutableMessageReferenceData withType(int value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableMessageReferenceData(this, value, this.messageId(), this.channelId(), this.guildId(), this.failIfNotExists());
    }

    public ImmutableMessageReferenceData withMessageId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageReferenceData(this, this.type, newValue, this.channelId(), this.guildId(), this.failIfNotExists());
    }

    public ImmutableMessageReferenceData withMessageId(long value) {
        Possible newValue = Possible.of((Object)Id.of((long)value));
        return new ImmutableMessageReferenceData(this, this.type, (Possible<Id>)newValue, this.channelId(), this.guildId(), this.failIfNotExists());
    }

    public ImmutableMessageReferenceData withChannelId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageReferenceData(this, this.type, this.messageId(), newValue, this.guildId(), this.failIfNotExists());
    }

    public ImmutableMessageReferenceData withChannelId(long value) {
        Possible newValue = Possible.of((Object)Id.of((long)value));
        return new ImmutableMessageReferenceData(this, this.type, this.messageId(), (Possible<Id>)newValue, this.guildId(), this.failIfNotExists());
    }

    public ImmutableMessageReferenceData withGuildId(Possible<Id> value) {
        Possible<Id> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageReferenceData(this, this.type, this.messageId(), this.channelId(), newValue, this.failIfNotExists());
    }

    public ImmutableMessageReferenceData withGuildId(long value) {
        Possible newValue = Possible.of((Object)Id.of((long)value));
        return new ImmutableMessageReferenceData(this, this.type, this.messageId(), this.channelId(), (Possible<Id>)newValue, this.failIfNotExists());
    }

    public ImmutableMessageReferenceData withFailIfNotExists(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new ImmutableMessageReferenceData(this, this.type, this.messageId(), this.channelId(), this.guildId(), newValue);
    }

    public ImmutableMessageReferenceData withFailIfNotExists(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new ImmutableMessageReferenceData(this, this.type, this.messageId(), this.channelId(), this.guildId(), (Possible<Boolean>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageReferenceData && this.equalTo(0, (ImmutableMessageReferenceData)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageReferenceData another) {
        return this.type == another.type && this.messageId().equals(another.messageId()) && this.channelId().equals(another.channelId()) && this.guildId().equals(another.guildId()) && this.failIfNotExists().equals(another.failIfNotExists());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type;
        h += (h << 5) + this.messageId().hashCode();
        h += (h << 5) + this.channelId().hashCode();
        h += (h << 5) + this.guildId().hashCode();
        h += (h << 5) + this.failIfNotExists().hashCode();
        return h;
    }

    public String toString() {
        return "MessageReferenceData{type=" + this.type + ", messageId=" + this.messageId().toString() + ", channelId=" + this.channelId().toString() + ", guildId=" + this.guildId().toString() + ", failIfNotExists=" + this.failIfNotExists().toString() + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMessageReferenceData fromJson(Json json) {
        Builder builder = ImmutableMessageReferenceData.builder();
        if (json.typeIsSet) {
            builder.type(json.type);
        }
        if (json.messageId != null) {
            builder.messageId(json.messageId);
        }
        if (json.channelId != null) {
            builder.channelId(json.channelId);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.failIfNotExists != null) {
            builder.failIfNotExists(json.failIfNotExists);
        }
        return builder.build();
    }

    public static ImmutableMessageReferenceData of(int type, Possible<Id> messageId, Possible<Id> channelId, Possible<Id> guildId, Possible<Boolean> failIfNotExists) {
        return new ImmutableMessageReferenceData(type, messageId, channelId, guildId, failIfNotExists);
    }

    public static ImmutableMessageReferenceData copyOf(MessageReferenceData instance) {
        if (instance instanceof ImmutableMessageReferenceData) {
            return (ImmutableMessageReferenceData)instance;
        }
        return ImmutableMessageReferenceData.builder().from(instance).build();
    }

    public boolean isMessageIdPresent() {
        return !this.messageId_absent;
    }

    public long messageIdOrElse(long defaultValue) {
        return !this.messageId_absent ? this.messageId_value : defaultValue;
    }

    public boolean isChannelIdPresent() {
        return !this.channelId_absent;
    }

    public long channelIdOrElse(long defaultValue) {
        return !this.channelId_absent ? this.channelId_value : defaultValue;
    }

    public boolean isGuildIdPresent() {
        return !this.guildId_absent;
    }

    public long guildIdOrElse(long defaultValue) {
        return !this.guildId_absent ? this.guildId_value : defaultValue;
    }

    public boolean isFailIfNotExistsPresent() {
        return !this.failIfNotExists_absent;
    }

    public Boolean failIfNotExistsOrElse(Boolean defaultValue) {
        return !this.failIfNotExists_absent ? this.failIfNotExists_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_TYPE = 1L;
        private long optBits;
        private Possible<Id> messageId_possible = Possible.absent();
        private Possible<Id> channelId_possible = Possible.absent();
        private Possible<Id> guildId_possible = Possible.absent();
        private Possible<Boolean> failIfNotExists_possible = Possible.absent();
        private int type;

        private Builder() {
        }

        public final Builder from(MessageReferenceData instance) {
            Objects.requireNonNull(instance, "instance");
            this.type(instance.type());
            this.messageId(instance.messageId());
            this.channelId(instance.channelId());
            this.guildId(instance.guildId());
            this.failIfNotExists(instance.failIfNotExists());
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(int type) {
            this.type = type;
            this.optBits |= 1L;
            return this;
        }

        public Builder messageId(String value) {
            this.messageId_possible = Possible.of((Object)Id.of((String)value));
            return this;
        }

        public Builder messageId(long value) {
            this.messageId_possible = Possible.of((Object)Id.of((long)value));
            return this;
        }

        public Builder messageId(Id value) {
            this.messageId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="message_id")
        public Builder messageId(Possible<Id> value) {
            this.messageId_possible = value;
            return this;
        }

        public Builder channelId(String value) {
            this.channelId_possible = Possible.of((Object)Id.of((String)value));
            return this;
        }

        public Builder channelId(long value) {
            this.channelId_possible = Possible.of((Object)Id.of((long)value));
            return this;
        }

        public Builder channelId(Id value) {
            this.channelId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="channel_id")
        public Builder channelId(Possible<Id> value) {
            this.channelId_possible = value;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_possible = Possible.of((Object)Id.of((String)value));
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_possible = Possible.of((Object)Id.of((long)value));
            return this;
        }

        public Builder guildId(Id value) {
            this.guildId_possible = Possible.of((Object)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Possible<Id> value) {
            this.guildId_possible = value;
            return this;
        }

        @JsonProperty(value="fail_if_not_exists")
        public Builder failIfNotExists(Possible<Boolean> value) {
            this.failIfNotExists_possible = value;
            return this;
        }

        public Builder failIfNotExists(Boolean value) {
            this.failIfNotExists_possible = Possible.of((Object)value);
            return this;
        }

        public ImmutableMessageReferenceData build() {
            return new ImmutableMessageReferenceData(this);
        }

        private boolean typeIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private Possible<Id> messageId_build() {
            return this.messageId_possible;
        }

        private Possible<Id> channelId_build() {
            return this.channelId_possible;
        }

        private Possible<Id> guildId_build() {
            return this.guildId_possible;
        }

        private Possible<Boolean> failIfNotExists_build() {
            return this.failIfNotExists_possible;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements MessageReferenceData {
        int type;
        boolean typeIsSet;
        Possible<Id> messageId = Possible.absent();
        Possible<Id> channelId = Possible.absent();
        Possible<Id> guildId = Possible.absent();
        Possible<Boolean> failIfNotExists = Possible.absent();

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(int type) {
            this.type = type;
            this.typeIsSet = true;
        }

        @JsonProperty(value="message_id")
        public void setMessageId(Possible<Id> messageId) {
            this.messageId = messageId;
        }

        @JsonProperty(value="channel_id")
        public void setChannelId(Possible<Id> channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Possible<Id> guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="fail_if_not_exists")
        public void setFailIfNotExists(Possible<Boolean> failIfNotExists) {
            this.failIfNotExists = failIfNotExists;
        }

        @Override
        public int type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> messageId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> channelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Id> guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Possible<Boolean> failIfNotExists() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private byte typeBuildStage = 0;
        private int type;

        private InitShim() {
        }

        int type() {
            if (this.typeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.typeBuildStage == 0) {
                this.typeBuildStage = (byte)-1;
                this.type = ImmutableMessageReferenceData.this.typeInitialize();
                this.typeBuildStage = 1;
            }
            return this.type;
        }

        void type(int type) {
            this.type = type;
            this.typeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.typeBuildStage == -1) {
                attributes.add("type");
            }
            return "Cannot build MessageReferenceData, attribute initializers form cycle " + attributes;
        }
    }
}

