/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.CreateTestEntitlementRequest;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ImmutableCreateTestEntitlementRequest
implements CreateTestEntitlementRequest {
    private final long skuId_value;
    private final long ownerId_value;
    private final int ownerType;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCreateTestEntitlementRequest(Id skuId, Id ownerId, int ownerType) {
        Id skuId$impl = skuId;
        Id ownerId$impl = ownerId;
        this.ownerType = ownerType;
        this.skuId_value = skuId$impl.asLong();
        this.ownerId_value = ownerId$impl.asLong();
        this.initShim = null;
    }

    private ImmutableCreateTestEntitlementRequest(ImmutableCreateTestEntitlementRequest original, Id skuId, Id ownerId, int ownerType) {
        Id skuId$impl = skuId;
        Id ownerId$impl = ownerId;
        this.ownerType = ownerType;
        this.skuId_value = skuId$impl.asLong();
        this.ownerId_value = ownerId$impl.asLong();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="sku_id")
    public Id skuId() {
        return Id.of((long)this.skuId_value);
    }

    @Override
    @JsonProperty(value="owner_id")
    public Id ownerId() {
        return Id.of((long)this.ownerId_value);
    }

    @Override
    @JsonProperty(value="owner_type")
    public int ownerType() {
        return this.ownerType;
    }

    public ImmutableCreateTestEntitlementRequest withSkuId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableCreateTestEntitlementRequest(this, newValue, this.ownerId(), this.ownerType);
    }

    public ImmutableCreateTestEntitlementRequest withSkuId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableCreateTestEntitlementRequest(this, newValue, this.ownerId(), this.ownerType);
    }

    public ImmutableCreateTestEntitlementRequest withOwnerId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableCreateTestEntitlementRequest(this, this.skuId(), newValue, this.ownerType);
    }

    public ImmutableCreateTestEntitlementRequest withOwnerId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableCreateTestEntitlementRequest(this, this.skuId(), newValue, this.ownerType);
    }

    public final ImmutableCreateTestEntitlementRequest withOwnerType(int value) {
        if (this.ownerType == value) {
            return this;
        }
        return new ImmutableCreateTestEntitlementRequest(this, this.skuId(), this.ownerId(), value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateTestEntitlementRequest && this.equalTo(0, (ImmutableCreateTestEntitlementRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableCreateTestEntitlementRequest another) {
        return Objects.equals(this.skuId_value, another.skuId_value) && Objects.equals(this.ownerId_value, another.ownerId_value) && this.ownerType == another.ownerType;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.skuId_value);
        h += (h << 5) + Objects.hashCode(this.ownerId_value);
        h += (h << 5) + this.ownerType;
        return h;
    }

    public String toString() {
        return "CreateTestEntitlementRequest{skuId=" + Objects.toString(this.skuId_value) + ", ownerId=" + Objects.toString(this.ownerId_value) + ", ownerType=" + this.ownerType + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCreateTestEntitlementRequest fromJson(Json json) {
        Builder builder = ImmutableCreateTestEntitlementRequest.builder();
        if (json.skuId != null) {
            builder.skuId(json.skuId);
        }
        if (json.ownerId != null) {
            builder.ownerId(json.ownerId);
        }
        if (json.ownerTypeIsSet) {
            builder.ownerType(json.ownerType);
        }
        return builder.build();
    }

    public static ImmutableCreateTestEntitlementRequest of(Id skuId, Id ownerId, int ownerType) {
        return new ImmutableCreateTestEntitlementRequest(skuId, ownerId, ownerType);
    }

    public static ImmutableCreateTestEntitlementRequest copyOf(CreateTestEntitlementRequest instance) {
        if (instance instanceof ImmutableCreateTestEntitlementRequest) {
            return (ImmutableCreateTestEntitlementRequest)instance;
        }
        return ImmutableCreateTestEntitlementRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_OWNER_TYPE = 1L;
        private long initBits = 1L;
        private Id skuId_id = null;
        private Id ownerId_id = null;
        private int ownerType;

        private Builder() {
        }

        public final Builder from(CreateTestEntitlementRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.skuId(instance.skuId());
            this.ownerId(instance.ownerId());
            this.ownerType(instance.ownerType());
            return this;
        }

        public Builder skuId(String value) {
            this.skuId_id = Id.of((String)value);
            return this;
        }

        public Builder skuId(long value) {
            this.skuId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="sku_id")
        public Builder skuId(Id value) {
            this.skuId_id = value;
            return this;
        }

        public Builder ownerId(String value) {
            this.ownerId_id = Id.of((String)value);
            return this;
        }

        public Builder ownerId(long value) {
            this.ownerId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="owner_id")
        public Builder ownerId(Id value) {
            this.ownerId_id = value;
            return this;
        }

        @JsonProperty(value="owner_type")
        public final Builder ownerType(int ownerType) {
            this.ownerType = ownerType;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCreateTestEntitlementRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateTestEntitlementRequest(null, this.skuId_build(), this.ownerId_build(), this.ownerType);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ownerType");
            }
            return "Cannot build CreateTestEntitlementRequest, some of required attributes are not set " + attributes;
        }

        private Id skuId_build() {
            return this.skuId_id;
        }

        private Id ownerId_build() {
            return this.ownerId_id;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements CreateTestEntitlementRequest {
        @Nullable
        Id skuId;
        @Nullable
        Id ownerId;
        int ownerType;
        boolean ownerTypeIsSet;

        Json() {
        }

        @JsonProperty(value="sku_id")
        public void setSkuId(Id skuId) {
            this.skuId = skuId;
        }

        @JsonProperty(value="owner_id")
        public void setOwnerId(Id ownerId) {
            this.ownerId = ownerId;
        }

        @JsonProperty(value="owner_type")
        public void setOwnerType(int ownerType) {
            this.ownerType = ownerType;
            this.ownerTypeIsSet = true;
        }

        @Override
        public Id skuId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id ownerId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int ownerType() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build CreateTestEntitlementRequest, attribute initializers form cycle " + attributes;
        }
    }
}

