/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AutoModActionData;
import discord4j.discordjson.json.AutoModRuleData;
import discord4j.discordjson.json.AutoModTriggerMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;

public final class ImmutableAutoModRuleData
implements AutoModRuleData {
    private final long id_value;
    private final String name;
    private final long creatorId_value;
    private final long guildId_value;
    private final int eventType;
    private final int triggerType;
    private final AutoModTriggerMetaData triggerMetadata;
    private final List<AutoModActionData> actions;
    private final boolean enabled;
    private final long[] exemptRoles_value;
    private final long[] exemptChannels_value;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAutoModRuleData(Id id, String name, Id creatorId, Id guildId, int eventType, int triggerType, AutoModTriggerMetaData triggerMetadata, Iterable<? extends AutoModActionData> actions, boolean enabled, List<Id> exemptRoles, List<Id> exemptChannels) {
        Id id$impl = id;
        this.name = Objects.requireNonNull(name, "name");
        Id creatorId$impl = creatorId;
        Id guildId$impl = guildId;
        this.eventType = eventType;
        this.triggerType = triggerType;
        this.triggerMetadata = Objects.requireNonNull(triggerMetadata, "triggerMetadata");
        this.actions = ImmutableAutoModRuleData.createUnmodifiableList(false, ImmutableAutoModRuleData.createSafeList(actions, true, false));
        this.enabled = enabled;
        List<Id> exemptRoles$impl = exemptRoles;
        List<Id> exemptChannels$impl = exemptChannels;
        this.id_value = id$impl.asLong();
        this.creatorId_value = creatorId$impl.asLong();
        this.guildId_value = guildId$impl.asLong();
        this.exemptRoles_value = exemptRoles$impl.stream().mapToLong(Id::asLong).toArray();
        this.exemptChannels_value = exemptChannels$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    private ImmutableAutoModRuleData(ImmutableAutoModRuleData original, Id id, String name, Id creatorId, Id guildId, int eventType, int triggerType, AutoModTriggerMetaData triggerMetadata, List<AutoModActionData> actions, boolean enabled, List<Id> exemptRoles, List<Id> exemptChannels) {
        Id id$impl = id;
        this.name = name;
        Id creatorId$impl = creatorId;
        Id guildId$impl = guildId;
        this.eventType = eventType;
        this.triggerType = triggerType;
        this.triggerMetadata = triggerMetadata;
        this.actions = actions;
        this.enabled = enabled;
        List<Id> exemptRoles$impl = exemptRoles;
        List<Id> exemptChannels$impl = exemptChannels;
        this.id_value = id$impl.asLong();
        this.creatorId_value = creatorId$impl.asLong();
        this.guildId_value = guildId$impl.asLong();
        this.exemptRoles_value = exemptRoles$impl.stream().mapToLong(Id::asLong).toArray();
        this.exemptChannels_value = exemptChannels$impl.stream().mapToLong(Id::asLong).toArray();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="id")
    public Id id() {
        return Id.of((long)this.id_value);
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="creator_id")
    public Id creatorId() {
        return Id.of((long)this.creatorId_value);
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of((long)this.guildId_value);
    }

    @Override
    @JsonProperty(value="event_type")
    public int eventType() {
        return this.eventType;
    }

    @Override
    @JsonProperty(value="trigger_type")
    public int triggerType() {
        return this.triggerType;
    }

    @Override
    @JsonProperty(value="trigger_metadata")
    public AutoModTriggerMetaData triggerMetadata() {
        return this.triggerMetadata;
    }

    @Override
    @JsonProperty(value="actions")
    public List<AutoModActionData> actions() {
        return this.actions;
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    @JsonProperty(value="exempt_roles")
    public List<Id> exemptRoles() {
        return LongStream.of(this.exemptRoles_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    @Override
    @JsonProperty(value="exempt_channels")
    public List<Id> exemptChannels() {
        return LongStream.of(this.exemptChannels_value).mapToObj(Id::of).collect(Collectors.toList());
    }

    public ImmutableAutoModRuleData withId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableAutoModRuleData(this, newValue, this.name, this.creatorId(), this.guildId(), this.eventType, this.triggerType, this.triggerMetadata, this.actions, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public ImmutableAutoModRuleData withId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableAutoModRuleData(this, newValue, this.name, this.creatorId(), this.guildId(), this.eventType, this.triggerType, this.triggerMetadata, this.actions, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public final ImmutableAutoModRuleData withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableAutoModRuleData(this, this.id(), newValue, this.creatorId(), this.guildId(), this.eventType, this.triggerType, this.triggerMetadata, this.actions, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public ImmutableAutoModRuleData withCreatorId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableAutoModRuleData(this, this.id(), this.name, newValue, this.guildId(), this.eventType, this.triggerType, this.triggerMetadata, this.actions, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public ImmutableAutoModRuleData withCreatorId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableAutoModRuleData(this, this.id(), this.name, newValue, this.guildId(), this.eventType, this.triggerType, this.triggerMetadata, this.actions, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public ImmutableAutoModRuleData withGuildId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableAutoModRuleData(this, this.id(), this.name, this.creatorId(), newValue, this.eventType, this.triggerType, this.triggerMetadata, this.actions, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public ImmutableAutoModRuleData withGuildId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableAutoModRuleData(this, this.id(), this.name, this.creatorId(), newValue, this.eventType, this.triggerType, this.triggerMetadata, this.actions, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public final ImmutableAutoModRuleData withEventType(int value) {
        if (this.eventType == value) {
            return this;
        }
        return new ImmutableAutoModRuleData(this, this.id(), this.name, this.creatorId(), this.guildId(), value, this.triggerType, this.triggerMetadata, this.actions, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public final ImmutableAutoModRuleData withTriggerType(int value) {
        if (this.triggerType == value) {
            return this;
        }
        return new ImmutableAutoModRuleData(this, this.id(), this.name, this.creatorId(), this.guildId(), this.eventType, value, this.triggerMetadata, this.actions, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public final ImmutableAutoModRuleData withTriggerMetadata(AutoModTriggerMetaData value) {
        if (this.triggerMetadata == value) {
            return this;
        }
        AutoModTriggerMetaData newValue = Objects.requireNonNull(value, "triggerMetadata");
        return new ImmutableAutoModRuleData(this, this.id(), this.name, this.creatorId(), this.guildId(), this.eventType, this.triggerType, newValue, this.actions, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public final ImmutableAutoModRuleData withActions(AutoModActionData ... elements) {
        List<AutoModActionData> newValue = ImmutableAutoModRuleData.createUnmodifiableList(false, ImmutableAutoModRuleData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAutoModRuleData(this, this.id(), this.name, this.creatorId(), this.guildId(), this.eventType, this.triggerType, this.triggerMetadata, newValue, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public final ImmutableAutoModRuleData withActions(Iterable<? extends AutoModActionData> elements) {
        if (this.actions == elements) {
            return this;
        }
        List<AutoModActionData> newValue = ImmutableAutoModRuleData.createUnmodifiableList(false, ImmutableAutoModRuleData.createSafeList(elements, true, false));
        return new ImmutableAutoModRuleData(this, this.id(), this.name, this.creatorId(), this.guildId(), this.eventType, this.triggerType, this.triggerMetadata, newValue, this.enabled, this.exemptRoles(), this.exemptChannels());
    }

    public final ImmutableAutoModRuleData withEnabled(boolean value) {
        if (this.enabled == value) {
            return this;
        }
        return new ImmutableAutoModRuleData(this, this.id(), this.name, this.creatorId(), this.guildId(), this.eventType, this.triggerType, this.triggerMetadata, this.actions, value, this.exemptRoles(), this.exemptChannels());
    }

    public ImmutableAutoModRuleData withExemptRoles(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableAutoModRuleData(this, this.id(), this.name, this.creatorId(), this.guildId(), this.eventType, this.triggerType, this.triggerMetadata, this.actions, this.enabled, newValue, this.exemptChannels());
    }

    public ImmutableAutoModRuleData withExemptChannels(List<Id> value) {
        List<Id> newValue = value;
        return new ImmutableAutoModRuleData(this, this.id(), this.name, this.creatorId(), this.guildId(), this.eventType, this.triggerType, this.triggerMetadata, this.actions, this.enabled, this.exemptRoles(), newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAutoModRuleData && this.equalTo(0, (ImmutableAutoModRuleData)another);
    }

    private boolean equalTo(int synthetic, ImmutableAutoModRuleData another) {
        return Objects.equals(this.id_value, another.id_value) && this.name.equals(another.name) && Objects.equals(this.creatorId_value, another.creatorId_value) && Objects.equals(this.guildId_value, another.guildId_value) && this.eventType == another.eventType && this.triggerType == another.triggerType && this.triggerMetadata.equals(another.triggerMetadata) && this.actions.equals(another.actions) && this.enabled == another.enabled && Objects.equals(this.exemptRoles_value, another.exemptRoles_value) && Objects.equals(this.exemptChannels_value, another.exemptChannels_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id_value);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.creatorId_value);
        h += (h << 5) + Objects.hashCode(this.guildId_value);
        h += (h << 5) + this.eventType;
        h += (h << 5) + this.triggerType;
        h += (h << 5) + this.triggerMetadata.hashCode();
        h += (h << 5) + this.actions.hashCode();
        h += (h << 5) + Boolean.hashCode(this.enabled);
        h += (h << 5) + Objects.hashCode(this.exemptRoles_value);
        h += (h << 5) + Objects.hashCode(this.exemptChannels_value);
        return h;
    }

    public String toString() {
        return "AutoModRuleData{id=" + Objects.toString(this.id_value) + ", name=" + this.name + ", creatorId=" + Objects.toString(this.creatorId_value) + ", guildId=" + Objects.toString(this.guildId_value) + ", eventType=" + this.eventType + ", triggerType=" + this.triggerType + ", triggerMetadata=" + this.triggerMetadata + ", actions=" + this.actions + ", enabled=" + this.enabled + ", exemptRoles=" + Objects.toString(this.exemptRoles_value) + ", exemptChannels=" + Objects.toString(this.exemptChannels_value) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAutoModRuleData fromJson(Json json) {
        Builder builder = ImmutableAutoModRuleData.builder();
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.creatorId != null) {
            builder.creatorId(json.creatorId);
        }
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.eventTypeIsSet) {
            builder.eventType(json.eventType);
        }
        if (json.triggerTypeIsSet) {
            builder.triggerType(json.triggerType);
        }
        if (json.triggerMetadata != null) {
            builder.triggerMetadata(json.triggerMetadata);
        }
        if (json.actions != null) {
            builder.addAllActions(json.actions);
        }
        if (json.enabledIsSet) {
            builder.enabled(json.enabled);
        }
        if (json.exemptRoles != null) {
            builder.exemptRoles(json.exemptRoles);
        }
        if (json.exemptChannels != null) {
            builder.exemptChannels(json.exemptChannels);
        }
        return builder.build();
    }

    public static ImmutableAutoModRuleData of(Id id, String name, Id creatorId, Id guildId, int eventType, int triggerType, AutoModTriggerMetaData triggerMetadata, List<AutoModActionData> actions, boolean enabled, List<Id> exemptRoles, List<Id> exemptChannels) {
        return ImmutableAutoModRuleData.of(id, name, creatorId, guildId, eventType, triggerType, triggerMetadata, actions, enabled, exemptRoles, exemptChannels);
    }

    public static ImmutableAutoModRuleData of(Id id, String name, Id creatorId, Id guildId, int eventType, int triggerType, AutoModTriggerMetaData triggerMetadata, Iterable<? extends AutoModActionData> actions, boolean enabled, List<Id> exemptRoles, List<Id> exemptChannels) {
        return new ImmutableAutoModRuleData(id, name, creatorId, guildId, eventType, triggerType, triggerMetadata, actions, enabled, exemptRoles, exemptChannels);
    }

    public static ImmutableAutoModRuleData copyOf(AutoModRuleData instance) {
        if (instance instanceof ImmutableAutoModRuleData) {
            return (ImmutableAutoModRuleData)instance;
        }
        return ImmutableAutoModRuleData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_EVENT_TYPE = 2L;
        private static final long INIT_BIT_TRIGGER_TYPE = 4L;
        private static final long INIT_BIT_TRIGGER_METADATA = 8L;
        private static final long INIT_BIT_ENABLED = 16L;
        private long initBits = 31L;
        private Id id_id = null;
        private Id creatorId_id = null;
        private Id guildId_id = null;
        private List<Long> exemptRoles_list = null;
        private List<Long> exemptChannels_list = null;
        @Nullable
        private String name;
        private int eventType;
        private int triggerType;
        @Nullable
        private AutoModTriggerMetaData triggerMetadata;
        private List<AutoModActionData> actions = new ArrayList<AutoModActionData>();
        private boolean enabled;

        private Builder() {
        }

        public final Builder from(AutoModRuleData instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.name(instance.name());
            this.creatorId(instance.creatorId());
            this.guildId(instance.guildId());
            this.eventType(instance.eventType());
            this.triggerType(instance.triggerType());
            this.triggerMetadata(instance.triggerMetadata());
            this.addAllActions(instance.actions());
            this.enabled(instance.enabled());
            this.exemptRoles(instance.exemptRoles());
            this.exemptChannels(instance.exemptChannels());
            return this;
        }

        public Builder id(String value) {
            this.id_id = Id.of((String)value);
            return this;
        }

        public Builder id(long value) {
            this.id_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="id")
        public Builder id(Id value) {
            this.id_id = value;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder creatorId(String value) {
            this.creatorId_id = Id.of((String)value);
            return this;
        }

        public Builder creatorId(long value) {
            this.creatorId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="creator_id")
        public Builder creatorId(Id value) {
            this.creatorId_id = value;
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of((String)value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        @JsonProperty(value="event_type")
        public final Builder eventType(int eventType) {
            this.eventType = eventType;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="trigger_type")
        public final Builder triggerType(int triggerType) {
            this.triggerType = triggerType;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="trigger_metadata")
        public final Builder triggerMetadata(AutoModTriggerMetaData triggerMetadata) {
            this.triggerMetadata = Objects.requireNonNull(triggerMetadata, "triggerMetadata");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder addAction(AutoModActionData element) {
            this.actions.add(Objects.requireNonNull(element, "actions element"));
            return this;
        }

        public final Builder addActions(AutoModActionData ... elements) {
            for (AutoModActionData element : elements) {
                this.actions.add(Objects.requireNonNull(element, "actions element"));
            }
            return this;
        }

        @JsonProperty(value="actions")
        public final Builder actions(Iterable<? extends AutoModActionData> elements) {
            this.actions.clear();
            return this.addAllActions(elements);
        }

        public final Builder addAllActions(Iterable<? extends AutoModActionData> elements) {
            for (AutoModActionData autoModActionData : elements) {
                this.actions.add(Objects.requireNonNull(autoModActionData, "actions element"));
            }
            return this;
        }

        @JsonProperty(value="enabled")
        public final Builder enabled(boolean enabled) {
            this.enabled = enabled;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder addExemptRole(long element) {
            this.exemptRoles_getOrCreate().add(element);
            return this;
        }

        public Builder addExemptRole(String element) {
            this.exemptRoles_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addExemptRole(Id element) {
            this.exemptRoles_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllExemptRoles(List<Long> elements) {
            this.exemptRoles_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="exempt_roles")
        public Builder exemptRoles(List<Id> elements) {
            this.exemptRoles_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder exemptRoles(Iterable<Id> elements) {
            this.exemptRoles_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder addExemptChannel(long element) {
            this.exemptChannels_getOrCreate().add(element);
            return this;
        }

        public Builder addExemptChannel(String element) {
            this.exemptChannels_getOrCreate().add(Id.of((String)element).asLong());
            return this;
        }

        public Builder addExemptChannel(Id element) {
            this.exemptChannels_getOrCreate().add(element.asLong());
            return this;
        }

        public Builder addAllExemptChannels(List<Long> elements) {
            this.exemptChannels_getOrCreate().addAll(elements);
            return this;
        }

        @JsonProperty(value="exempt_channels")
        public Builder exemptChannels(List<Id> elements) {
            this.exemptChannels_list = elements.stream().map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public Builder exemptChannels(Iterable<Id> elements) {
            this.exemptChannels_list = StreamSupport.stream(elements.spliterator(), false).map(Id::asLong).collect(Collectors.toList());
            return this;
        }

        public ImmutableAutoModRuleData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAutoModRuleData(null, this.id_build(), this.name, this.creatorId_build(), this.guildId_build(), this.eventType, this.triggerType, this.triggerMetadata, ImmutableAutoModRuleData.createUnmodifiableList(true, this.actions), this.enabled, this.exemptRoles_build(), this.exemptChannels_build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("eventType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("triggerType");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("triggerMetadata");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("enabled");
            }
            return "Cannot build AutoModRuleData, some of required attributes are not set " + attributes;
        }

        private Id id_build() {
            return this.id_id;
        }

        private Id creatorId_build() {
            return this.creatorId_id;
        }

        private Id guildId_build() {
            return this.guildId_id;
        }

        private List<Id> exemptRoles_build() {
            return this.exemptRoles_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> exemptRoles_getOrCreate() {
            if (this.exemptRoles_list == null) {
                this.exemptRoles_list = new ArrayList<Long>();
            }
            return this.exemptRoles_list;
        }

        private List<Id> exemptChannels_build() {
            return this.exemptChannels_getOrCreate().stream().map(Id::of).collect(Collectors.toList());
        }

        private List<Long> exemptChannels_getOrCreate() {
            if (this.exemptChannels_list == null) {
                this.exemptChannels_list = new ArrayList<Long>();
            }
            return this.exemptChannels_list;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements AutoModRuleData {
        @Nullable
        Id id;
        @Nullable
        String name;
        @Nullable
        Id creatorId;
        @Nullable
        Id guildId;
        int eventType;
        boolean eventTypeIsSet;
        int triggerType;
        boolean triggerTypeIsSet;
        @Nullable
        AutoModTriggerMetaData triggerMetadata;
        @Nullable
        List<AutoModActionData> actions = Collections.emptyList();
        boolean enabled;
        boolean enabledIsSet;
        @Nullable
        List<Id> exemptRoles;
        @Nullable
        List<Id> exemptChannels;

        Json() {
        }

        @JsonProperty(value="id")
        public void setId(Id id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="creator_id")
        public void setCreatorId(Id creatorId) {
            this.creatorId = creatorId;
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="event_type")
        public void setEventType(int eventType) {
            this.eventType = eventType;
            this.eventTypeIsSet = true;
        }

        @JsonProperty(value="trigger_type")
        public void setTriggerType(int triggerType) {
            this.triggerType = triggerType;
            this.triggerTypeIsSet = true;
        }

        @JsonProperty(value="trigger_metadata")
        public void setTriggerMetadata(AutoModTriggerMetaData triggerMetadata) {
            this.triggerMetadata = triggerMetadata;
        }

        @JsonProperty(value="actions")
        public void setActions(List<AutoModActionData> actions) {
            this.actions = actions;
        }

        @JsonProperty(value="enabled")
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.enabledIsSet = true;
        }

        @JsonProperty(value="exempt_roles")
        public void setExemptRoles(List<Id> exemptRoles) {
            this.exemptRoles = exemptRoles;
        }

        @JsonProperty(value="exempt_channels")
        public void setExemptChannels(List<Id> exemptChannels) {
            this.exemptChannels = exemptChannels;
        }

        @Override
        public Id id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id creatorId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int eventType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int triggerType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AutoModTriggerMetaData triggerMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AutoModActionData> actions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean enabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> exemptRoles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Id> exemptChannels() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build AutoModRuleData, attribute initializers form cycle " + attributes;
        }
    }
}

