/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.sinks;

import discord4j.common.sinks.EmissionStrategy;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import reactor.core.publisher.Sinks;
import reactor.util.Logger;
import reactor.util.Loggers;

class TimeoutEmissionStrategy
implements EmissionStrategy {
    private static final Logger log = Loggers.getLogger(TimeoutEmissionStrategy.class);
    private final long parkNanos;
    private final long timeoutNanos;
    private final boolean errorOnTimeout;

    TimeoutEmissionStrategy(long parkNanos, long timeoutNanos, boolean errorOnTimeout) {
        this.parkNanos = parkNanos;
        this.timeoutNanos = timeoutNanos;
        this.errorOnTimeout = errorOnTimeout;
    }

    @Override
    public <T> boolean emitNext(Sinks.Many<T> sink, T element) {
        Sinks.EmitResult emission;
        long remaining = 0L;
        if (this.timeoutNanos > 0L) {
            remaining = this.timeoutNanos;
        }
        block5: while (true) {
            if ((emission = sink.tryEmitNext(element)).isSuccess()) {
                return true;
            }
            if (this.timeoutNanos >= 0L && (remaining -= this.parkNanos) <= 0L) {
                log.debug("Emission timed out at {}: {}", new Object[]{sink.name(), element.toString()});
                if (this.errorOnTimeout) {
                    throw new Sinks.EmissionException(emission, "Emission timed out");
                }
                return false;
            }
            switch (emission) {
                case FAIL_ZERO_SUBSCRIBER: 
                case FAIL_CANCELLED: 
                case FAIL_TERMINATED: {
                    return false;
                }
                case FAIL_NON_SERIALIZED: {
                    LockSupport.parkNanos(this.parkNanos);
                    continue block5;
                }
                case FAIL_OVERFLOW: {
                    log.trace("Emission overflowing at {}: {}", new Object[]{sink.name(), element.toString()});
                    LockSupport.parkNanos(this.parkNanos);
                    continue block5;
                }
            }
            break;
        }
        throw new Sinks.EmissionException(emission, "Unknown emitResult value");
    }

    @Override
    public <T> boolean emitComplete(Sinks.Many<T> sink) {
        return this.emitTerminal(() -> sink.tryEmitComplete());
    }

    @Override
    public <T> boolean emitError(Sinks.Many<T> sink, Throwable error) {
        return this.emitTerminal(() -> sink.tryEmitError(error));
    }

    private <T> boolean emitTerminal(Supplier<Sinks.EmitResult> resultSupplier) {
        Sinks.EmitResult emission;
        long remaining = 0L;
        if (this.timeoutNanos > 0L) {
            remaining = this.timeoutNanos;
        }
        block4: while (true) {
            if ((emission = resultSupplier.get()).isSuccess()) {
                return true;
            }
            if (this.timeoutNanos >= 0L && (remaining -= this.parkNanos) <= 0L) {
                if (this.errorOnTimeout) {
                    throw new Sinks.EmissionException(emission, "Emission timed out");
                }
                return false;
            }
            switch (emission) {
                case FAIL_ZERO_SUBSCRIBER: 
                case FAIL_CANCELLED: 
                case FAIL_TERMINATED: 
                case FAIL_OVERFLOW: {
                    return false;
                }
                case FAIL_NON_SERIALIZED: {
                    LockSupport.parkNanos(this.parkNanos);
                    continue block4;
                }
            }
            break;
        }
        throw new Sinks.EmissionException(emission, "Unknown emitResult value");
    }
}

