/*
 * Decompiled with CFR 0.152.
 */
package com.inet.shared.diagnostics.widgets.jobs;

import com.inet.annotations.InternalApi;
import com.inet.remote.gui.angular.ServiceMethod;
import com.inet.shared.diagnostics.shared.DiagnosticsWidgetProvider;
import com.inet.shared.diagnostics.shared.model.DiagnosticWidget;
import com.inet.shared.diagnostics.shared.model.DiagnosticWidgetDetails;
import com.inet.shared.diagnostics.widgets.jobs.a;
import com.inet.shared.diagnostics.widgets.jobs.model.JobsDetails;
import com.inet.shared.diagnostics.widgets.jobs.model.JobsShortDetails;
import com.inet.thread.job.JobInfo;
import com.inet.thread.job.manager.JobManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public class JobsDiagnosticsWidget
implements DiagnosticsWidgetProvider {
    public static final String KEY = "jobs";

    @Override
    public DiagnosticWidget getWidgetBean() {
        return new DiagnosticWidget(KEY, "stat_jobs");
    }

    @Override
    public JobsDetails getWidgetDetails() {
        List list = JobManager.instance().informationAboutJobs();
        return new JobsDetails(list);
    }

    @Override
    public DiagnosticWidgetDetails getWidgetShortDetails() {
        int n = 0;
        int n2 = 0;
        List list = JobManager.instance().informationAboutJobs();
        for (JobInfo jobInfo : list) {
            switch (jobInfo.getState()) {
                case FAILED: 
                case FINISHED: 
                case TERMINATED: {
                    break;
                }
                case PAUSED: 
                case READY: {
                    ++n2;
                    break;
                }
                case STARTED: 
                case PAUSING: 
                case STARTING: 
                case TERMINATING: {
                    ++n;
                    break;
                }
            }
        }
        return new JobsShortDetails(n, n2);
    }

    @Override
    public List<ServiceMethod> getServiceMethods() {
        ArrayList<ServiceMethod> arrayList = new ArrayList<ServiceMethod>();
        arrayList.add(new a(this));
        return arrayList;
    }

    @Override
    public URL[] getWidgetJSPath() {
        return new URL[]{this.getClass().getResource("resources/jobs.js")};
    }

    @Override
    public URL[] getWidgetCSSPath() {
        return null;
    }

    @Override
    public URL getTemplateUrl() {
        return this.getClass().getResource("resources/jobs.html");
    }

    @Override
    public URL getShortTemplateUrl() {
        return this.getClass().getResource("resources/short.html");
    }

    @Override
    public int getSortPriority() {
        return 58;
    }
}

