/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing.control;

import com.inet.annotations.InternalApi;
import com.inet.swing.border.GlassButtonBorder;
import com.inet.swing.control.Control;
import com.inet.swing.control.ControlManager;
import com.inet.swing.control.GlassButtonUI;
import com.inet.swing.control.SideBar;
import com.inet.swing.control.d;
import com.inet.swing.search.Searchable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;

@InternalApi
public class SideNavigationBar
extends SideBar
implements d {
    public static final String PROPERTY_MIN_WIDTH = "NavigationBar.MinWidth";
    private a fL = new a();
    private c fM;
    private int fN = 100;
    private int fO = 250;

    public SideNavigationBar(ControlManager manager) {
        this.a(manager);
    }

    public static int getWidthForControl(Control control) {
        JToggleButton jToggleButton = new JToggleButton();
        jToggleButton.setHorizontalAlignment(2);
        jToggleButton.setHorizontalTextPosition(4);
        jToggleButton.setText(control.getName());
        jToggleButton.setIcon(control.getIcon());
        return jToggleButton.getMinimumSize().width;
    }

    private JToggleButton a(Control control, boolean bl) {
        JToggleButton jToggleButton = new JToggleButton(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                return new Dimension(Math.min(SideNavigationBar.this.fO, Math.max(SideNavigationBar.this.fN, dimension.width)), dimension.height);
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                return new Dimension(Math.max(SideNavigationBar.this.fN, dimension.width), dimension.height);
            }

            @Override
            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                return new Dimension(Math.min(SideNavigationBar.this.fO, dimension.width), dimension.height);
            }
        };
        if (bl && control instanceof Searchable) {
            ((Searchable)((Object)control)).setActivateObjects(jToggleButton);
        }
        jToggleButton.setHorizontalAlignment(2);
        jToggleButton.setHorizontalTextPosition(4);
        jToggleButton.setText(control.getName());
        jToggleButton.setIcon(control.getIcon());
        jToggleButton.setName("com.inet.lib.navigationbar." + control.getName());
        jToggleButton.putClientProperty("CONTROL_NAME", control.getName());
        return jToggleButton;
    }

    private void a(ControlManager controlManager) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(Color.WHITE);
        jPanel.setOpaque(true);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.fM = new c(jPanel, controlManager);
        super.setContent(jPanel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object object;
        Control control;
        if (evt.getPropertyName().equals("SELECTED")) {
            control = (Control)evt.getNewValue();
            object = control.getName();
            for (int i2 = 0; i2 < this.fM.fT.size(); ++i2) {
                JToggleButton jToggleButton = this.fM.fT.get((int)i2).fR;
                if (!jToggleButton.getClientProperty("CONTROL_NAME").equals(object)) continue;
                this.fM.fv = i2;
                Point point = SwingUtilities.convertPoint(jToggleButton, jToggleButton.getLocation(), this);
                jToggleButton.scrollRectToVisible(new Rectangle(point));
                break;
            }
            JToggleButton jToggleButton = this.fM.fT.get((int)this.fM.fv).fR;
            jToggleButton.setSelected(true);
        }
        if (evt.getPropertyName().equals("ADD")) {
            control = (Control)evt.getNewValue();
            object = (Integer)evt.getOldValue();
            if (object == null) {
                this.fM.add(control);
            } else {
                this.fM.a(control, (Integer)object);
            }
            this.revalidate();
        }
        if (evt.getPropertyName().equals("REMOVE")) {
            control = (Control)evt.getNewValue();
            this.fM.b(control);
            this.revalidate();
        }
    }

    @Override
    public void setBarProperties(Properties properties) {
        if (properties.containsKey(PROPERTY_MIN_WIDTH)) {
            this.fN = Integer.valueOf(properties.getProperty(PROPERTY_MIN_WIDTH));
        }
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    class a
    implements ActionListener {
        a() {
        }

        private String e(JComponent jComponent) {
            String string = (String)jComponent.getClientProperty("CONTROL_NAME");
            if (string != null && string.trim().length() > 0) {
                return string;
            }
            Container container = jComponent.getParent();
            if (container != null && container instanceof JComponent) {
                return this.e((JComponent)container);
            }
            return null;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            JComponent jComponent;
            String string;
            if (e2.getSource() instanceof JComponent && (string = this.e(jComponent = (JComponent)e2.getSource())) != null && string.trim().length() > 0) {
                SideNavigationBar.this.firePropertyChange("SELECTED", null, string);
            }
        }
    }

    class c {
        private Box fS = Box.createVerticalBox();
        private int fv = 0;
        private ArrayList<b> fT = new ArrayList();
        private ButtonGroup fU = new ButtonGroup();
        private boolean fV;

        c(JPanel jPanel, ControlManager controlManager) {
            jPanel.add(this.fS);
            this.fV = controlManager.getControlCount() > 1;
            for (int i2 = 0; i2 < controlManager.getControlCount(); ++i2) {
                this.add(controlManager.getControl(i2));
            }
            this.fS.addContainerListener(new ContainerAdapter(){

                @Override
                public void componentAdded(ContainerEvent e2) {
                    SideNavigationBar.this.checkSize();
                }

                @Override
                public void componentRemoved(ContainerEvent e2) {
                    SideNavigationBar.this.checkSize();
                }
            });
        }

        void add(Control control) {
            this.a(control, this.fT.size());
        }

        void a(Control control, int n2) {
            b b2 = new b();
            b2.fR = SideNavigationBar.this.a(control, this.fV);
            this.fU.add(b2.fR);
            b2.fR.setUI(new GlassButtonUI(b2.fR));
            b2.fR.setBorder(new GlassButtonBorder(new Insets(3, 6, 3, 6)));
            b2.fR.setRolloverEnabled(true);
            b2.fR.addActionListener(SideNavigationBar.this.fL);
            b2.fQ = this.a(b2.fR);
            if (this.fT.size() == 0) {
                this.fS.add(b2.fQ);
                this.fT.add(0, b2);
            } else if (n2 == this.fT.size()) {
                this.fS.add(Box.createVerticalStrut(10));
                this.fS.add(b2.fQ);
                this.fT.add(b2);
            } else {
                JPanel jPanel = this.fT.get((int)n2).fQ;
                int n3 = -1;
                for (int i2 = 0; i2 < this.fS.getComponentCount(); ++i2) {
                    if (jPanel != this.fS.getComponent(i2)) continue;
                    n3 = i2;
                    break;
                }
                if (n3 == -1) {
                    n3 = this.fS.getComponentCount();
                }
                if (this.fv >= n2) {
                    ++this.fv;
                }
                this.fS.add((Component)b2.fQ, n3);
                this.fS.add(Box.createVerticalStrut(10), n3 + 1);
                this.fT.add(n2, b2);
            }
        }

        private JPanel a(JToggleButton jToggleButton) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jToggleButton, "Center");
            return jPanel;
        }

        void b(Control control) {
            int n2;
            int n3 = -1;
            for (int i2 = 0; i2 < this.fT.size(); ++i2) {
                b b2 = this.fT.get(i2);
                if (!b2.fR.getClientProperty("CONTROL_NAME").equals(control.getName())) continue;
                n3 = i2;
                break;
            }
            if (n3 == -1) {
                return;
            }
            b b3 = this.fT.get(n3);
            b3.fR.removeActionListener(SideNavigationBar.this.fL);
            this.fU.remove(b3.fR);
            int n4 = -1;
            for (n2 = 0; n2 < this.fS.getComponentCount(); ++n2) {
                if (b3.fQ != this.fS.getComponent(n2)) continue;
                n4 = n2;
                break;
            }
            if (n4 < this.fS.getComponentCount() - 1) {
                this.fS.remove(n4 + 1);
            }
            this.fS.remove(n4);
            int n5 = n2 = this.fv == n3 ? 1 : 0;
            if (this.fv > n3) {
                --this.fv;
            }
            this.fT.remove(b3);
            if (this.fv >= this.fT.size()) {
                this.fv = this.fT.size() - 1;
            }
            if (n2 != 0) {
                b3 = this.fT.get(this.fv);
                String string = (String)b3.fR.getClientProperty("CONTROL_NAME");
                if (string != null && string.trim().length() > 0) {
                    SideNavigationBar.this.firePropertyChange("SELECTED", null, string);
                }
            }
        }
    }

    static class b {
        private JPanel fQ;
        private JToggleButton fR;

        b() {
        }
    }
}

