/*
 * Decompiled with CFR 0.152.
 */
package com.inet.swing.control;

import com.inet.annotations.InternalApi;
import com.inet.swing.InetLookAndFeel;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;

@InternalApi
public class GlassButtonUI
extends BasicButtonUI {
    private static GlassButtonUI fA = null;

    public GlassButtonUI(JComponent c2) {
    }

    @Override
    protected void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
    }

    public static ComponentUI createUI(JComponent c2) {
        if (fA == null) {
            fA = new GlassButtonUI(c2);
        }
        return fA;
    }

    @Override
    public void update(Graphics g2, JComponent c2) {
        if (c2.isOpaque()) {
            AbstractButton abstractButton = (AbstractButton)c2;
            if (this.a(abstractButton)) {
                c2.setOpaque(false);
            } else if (abstractButton.isContentAreaFilled()) {
                InetLookAndFeel.paintGradient(g2, InetLookAndFeel.ILNF_BUTTON_COLOR, 0, 0, c2.getWidth(), c2.getHeight());
            }
        }
        this.paint(g2, c2);
    }

    private boolean a(AbstractButton abstractButton) {
        Container container = abstractButton.getParent();
        return container != null && (container instanceof JToolBar || container.getParent() instanceof JToolBar);
    }

    @Override
    public void paint(Graphics g2, JComponent c2) {
        AbstractButton abstractButton = (AbstractButton)c2;
        ButtonModel buttonModel = abstractButton.getModel();
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        FontMetrics fontMetrics = g2.getFontMetrics();
        Insets insets = c2.getInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = abstractButton.getWidth() - (insets.right + rectangle.x);
        rectangle.height = abstractButton.getHeight() - (insets.bottom + rectangle.y);
        rectangle2.height = 0;
        rectangle2.width = 0;
        rectangle2.y = 0;
        rectangle2.x = 0;
        rectangle3.height = 0;
        rectangle3.width = 0;
        rectangle3.y = 0;
        rectangle3.x = 0;
        Font font = c2.getFont();
        g2.setFont(font);
        String string = SwingUtilities.layoutCompoundLabel(c2, fontMetrics, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle3, rectangle2, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        this.clearTextShiftOffset();
        if (abstractButton.isEnabled()) {
            if (abstractButton.isFocusPainted() && abstractButton.hasFocus()) {
                InetLookAndFeel.paintGradient(g2, InetLookAndFeel.ILNF_BUTTON_FOCUSED_COLOR, 0, 0, c2.getWidth(), c2.getHeight());
            }
            if (buttonModel.isRollover()) {
                InetLookAndFeel.paintGradient(g2, InetLookAndFeel.ILNF_BUTTON_ROLLOVER_COLOR, 0, 0, c2.getWidth(), c2.getHeight());
            }
            if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                InetLookAndFeel.paintGradient(g2, InetLookAndFeel.ILNF_BUTTON_PRESSED_COLOR, 0, 0, c2.getWidth(), c2.getHeight());
            }
        } else {
            InetLookAndFeel.paintGradient(g2, InetLookAndFeel.ILNF_BUTTON_DISABLED_COLOR, 0, 0, c2.getWidth(), c2.getHeight());
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon(g2, c2, rectangle3);
        }
        if (string != null && !string.equals("")) {
            View view = (View)c2.getClientProperty("html");
            if (view != null) {
                view.paint(g2, rectangle2);
            } else {
                this.paintText(g2, abstractButton, rectangle2, string);
            }
        }
    }
}

