/*
 * Decompiled with CFR 0.152.
 */
package com.inet.guilib;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;

public class GUIUtilities {
    public static void disposeOnEscape(final JDialog dialog) {
        KeyStroke ksEscape = KeyStroke.getKeyStroke(27, 0);
        String key = "escape_dialog";
        dialog.getRootPane().getInputMap(2).put(ksEscape, key);
        dialog.getRootPane().getActionMap().put(key, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
    }

    public static void hideOnEscape(final JPopupMenu popup) {
        KeyStroke ksEscape = KeyStroke.getKeyStroke(27, 0);
        String key = "escape_popup";
        popup.getInputMap(2).put(ksEscape, key);
        popup.getActionMap().put(key, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.setVisible(false);
            }
        });
    }

    public static JPopupMenu createPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        GUIUtilities.hideOnEscape(popup);
        return popup;
    }

    public static void registerComponentForInstantTooltip(JComponent c) {
        InputMap imap = c.getInputMap();
        c.getActionMap();
        boolean removeKeyStroke = false;
        KeyStroke[] ks = imap.keys();
        if (ks == null || ks.length == 0) {
            imap.put(KeyStroke.getKeyStroke(92, 0), "backSlash");
            removeKeyStroke = true;
        }
        ToolTipManager.sharedInstance().registerComponent(c);
        if (removeKeyStroke) {
            imap.remove(KeyStroke.getKeyStroke(92, 0));
        }
        c.addMouseListener(new MouseHandler());
    }

    static class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JComponent c = (JComponent)e.getComponent();
            Action action = c.getActionMap().get("postTip");
            if (action != null) {
                action.actionPerformed(new ActionEvent(c, 1001, "postTip"));
            }
        }
    }
}

