/*
 * Decompiled with CFR 0.152.
 */
package com.inet.guilib;

import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public abstract class AsyncWorker<T, V>
extends SwingWorker<T, V> {
    public static final String PROPERTY_PROGRESS = "progress";
    public static final String PROPERTY_STATE = "state";
    public static final String PROPERTY_UNLOCK = "unlock";
    public static final int MIN_TIME_OFF = 200;
    public static final int MIN_TIME_PROGRESS = 500;
    private Type type = Type.INDETERMINATE;
    private String message;
    private DefaultBoundedRangeModel progressModel = new DefaultBoundedRangeModel();
    private AtomicLong startTime = new AtomicLong();
    private boolean atomic;

    @Override
    protected final T doInBackground() throws Exception {
        this.startTime.set(System.currentTimeMillis());
        try {
            T t = this.call();
            return t;
        }
        finally {
            this.tryToSleep();
        }
    }

    @Override
    protected final void process(List<V> list) {
        this.firePropertyChange(PROPERTY_PROGRESS, null, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void done() {
        State state;
        Object t = null;
        Exception e = null;
        try {
            t = this.get();
        }
        catch (Exception ex) {
            State state2;
            try {
                e = ex;
            }
            catch (Throwable throwable) {
                State state3;
                State state4 = this.isCancelled() ? State.CANCEL : (state3 = e != null ? State.EXCEPTION : State.SUCCESS);
                Exception result = state3 == State.CANCEL ? null : (state3 == State.EXCEPTION ? e : t);
                this.firePropertyChange(PROPERTY_UNLOCK, (Object)state3, result);
                Exception exc = e;
                Object t_ = t;
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ State val$state;
                    final /* synthetic */ Exception val$exc;
                    final /* synthetic */ Object val$t_;
                    {
                        this.val$state = state;
                        this.val$exc = exception;
                        this.val$t_ = object;
                    }

                    @Override
                    public void run() {
                        switch (this.val$state) {
                            case EXCEPTION: {
                                AsyncWorker.this.onFailure(this.val$exc == null || this.val$exc.getCause() == null ? this.val$exc : this.val$exc.getCause());
                                break;
                            }
                            case SUCCESS: {
                                AsyncWorker.this.onSuccess(this.val$t_);
                                break;
                            }
                            case CANCEL: {
                                AsyncWorker.this.onCancel();
                            }
                        }
                    }
                });
                throw throwable;
            }
            State state5 = this.isCancelled() ? State.CANCEL : (state2 = e != null ? State.EXCEPTION : State.SUCCESS);
            Exception result = state2 == State.CANCEL ? null : (state2 == State.EXCEPTION ? e : t);
            this.firePropertyChange(PROPERTY_UNLOCK, (Object)state2, result);
            Exception exc = e;
            Object t_ = t;
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        State state6 = this.isCancelled() ? State.CANCEL : (state = e != null ? State.EXCEPTION : State.SUCCESS);
        Exception result = state == State.CANCEL ? null : (state == State.EXCEPTION ? e : t);
        this.firePropertyChange(PROPERTY_UNLOCK, (Object)state, result);
        Exception exc = e;
        Object t_ = t;
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public final long getTime() {
        return System.currentTimeMillis() - this.startTime.get();
    }

    private void tryToSleep() {
        long time = this.getTime();
        int minT = this.getMinimumTime();
        int maxT = minT + this.getSleepTime();
        if (time >= (long)minT && time <= (long)maxT) {
            try {
                Thread.sleep((long)maxT - time);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setType(Type type) {
        if (type != null) {
            this.type = type;
        }
    }

    public Type getType() {
        return this.type;
    }

    public boolean isTypeOf(Type progressType) {
        return progressType == this.getType();
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isAtomic() {
        return this.atomic;
    }

    public void setAtomic(boolean atomic) {
        this.atomic = atomic;
    }

    public DefaultBoundedRangeModel getProgressModel() {
        return this.progressModel;
    }

    public void setProgressModel(DefaultBoundedRangeModel progressModel) {
        if (progressModel != null) {
            this.progressModel = progressModel;
        }
    }

    public int getMinimumTime() {
        return this.isTypeOf(Type.OFF) ? 200 : 500;
    }

    public int getSleepTime() {
        return 500;
    }

    public abstract T call() throws Exception;

    public abstract void onSuccess(T var1);

    public abstract void onFailure(Throwable var1);

    public void onCancel() {
    }

    public String paramString() {
        StringBuilder sb = new StringBuilder(20);
        sb.append("state=" + String.valueOf((Object)this.getState()));
        sb.append(",type=" + String.valueOf((Object)this.getType()));
        sb.append(",atomic=" + this.isAtomic());
        sb.append(",canceled=" + this.isCancelled());
        sb.append(",time duration=" + this.getTime());
        sb.append(",message=" + this.getMessage());
        sb.append(",toString=" + this.toString());
        return sb.toString();
    }

    public static enum Type {
        INDETERMINATE,
        DETERMINATE,
        OFF;

    }

    public static enum State {
        CANCEL,
        EXCEPTION,
        SUCCESS;

    }
}

